var {:race_checking} _READ_HAS_OCCURRED_$$outputArray$1: bool;

var {:race_checking} _WRITE_HAS_OCCURRED_$$outputArray$1: bool;

var {:race_checking} {:elem_width 32} _READ_OFFSET_$$outputArray$1: bv32;

var {:race_checking} {:elem_width 32} _WRITE_OFFSET_$$outputArray$1: bv32;

var {:global} $$sortedArray: [bv32]bv32;

var {:race_checking} _READ_HAS_OCCURRED_$$sortedArray$1: bool;

var {:race_checking} _WRITE_HAS_OCCURRED_$$sortedArray$1: bool;

var {:race_checking} {:elem_width 32} _READ_OFFSET_$$sortedArray$1: bv32;

var {:race_checking} {:elem_width 32} _WRITE_OFFSET_$$sortedArray$1: bv32;

const {:group_id_x} group_id_x$1: bv32;

const {:group_id_x} group_id_x$2: bv32;

const {:group_size_x} group_size_x: bv32;

const {:group_size_y} group_size_y: bv32;

const {:group_size_z} group_size_z: bv32;

const {:local_id_x} local_id_x$1: bv32;

const {:local_id_x} local_id_x$2: bv32;

const {:num_groups_x} num_groups_x: bv32;

const {:num_groups_y} num_groups_y: bv32;

const {:num_groups_z} num_groups_z: bv32;

function {:bvbuiltin "bvadd"} BV32_ADD(bv32, bv32) : bv32;

function {:bvbuiltin "bvmul"} BV32_MUL(bv32, bv32) : bv32;

function {:bvbuiltin "bvsub"} BV32_SUB(bv32, bv32) : bv32;

function {:bvbuiltin "bvugt"} BV32_UGT(bv32, bv32) : bool;

function {:bvbuiltin "bvult"} BV32_ULT(bv32, bv32) : bool;

procedure {:kernel} $binarySearch($findMe: bv32, $globalLowerBound: bv32, $globalUpperBound: bv32, $subdivSize: bv32);
  requires !_READ_HAS_OCCURRED_$$outputArray$1 && !_WRITE_HAS_OCCURRED_$$outputArray$1;
  requires _READ_SOURCE_$$outputArray$1 == 0bv32;
  requires _WRITE_SOURCE_$$outputArray$1 == 0bv32;
  requires !_READ_HAS_OCCURRED_$$sortedArray$1 && !_WRITE_HAS_OCCURRED_$$sortedArray$1;
  requires _READ_SOURCE_$$sortedArray$1 == 0bv32;
  requires _WRITE_SOURCE_$$sortedArray$1 == 0bv32;
  requires BV32_SGT(group_size_x, 0bv32);
  requires BV32_SGT(num_groups_x, 0bv32);
  requires BV32_SGE(group_id_x$1, 0bv32);
  requires BV32_SGE(group_id_x$2, 0bv32);
  requires BV32_SLT(group_id_x$1, num_groups_x);
  requires BV32_SLT(group_id_x$2, num_groups_x);
  requires BV32_SGE(local_id_x$1, 0bv32);
  requires BV32_SGE(local_id_x$2, 0bv32);
  requires BV32_SLT(local_id_x$1, group_size_x);
  requires BV32_SLT(local_id_x$2, group_size_x);
  requires BV32_SGT(group_size_y, 0bv32);
  requires BV32_SGT(num_groups_y, 0bv32);
  requires BV32_SGE(group_id_y$1, 0bv32);
  requires BV32_SGE(group_id_y$2, 0bv32);
  requires BV32_SLT(group_id_y$1, num_groups_y);
  requires BV32_SLT(group_id_y$2, num_groups_y);
  requires BV32_SGE(local_id_y$1, 0bv32);
  requires BV32_SGE(local_id_y$2, 0bv32);
  requires BV32_SLT(local_id_y$1, group_size_y);
  requires BV32_SLT(local_id_y$2, group_size_y);
  requires BV32_SGT(group_size_z, 0bv32);
  requires BV32_SGT(num_groups_z, 0bv32);
  requires BV32_SGE(group_id_z$1, 0bv32);
  requires BV32_SGE(group_id_z$2, 0bv32);
  requires BV32_SLT(group_id_z$1, num_groups_z);
  requires BV32_SLT(group_id_z$2, num_groups_z);
  requires BV32_SGE(local_id_z$1, 0bv32);
  requires BV32_SGE(local_id_z$2, 0bv32);
  requires BV32_SLT(local_id_z$1, group_size_z);
  requires BV32_SLT(local_id_z$2, group_size_z);
  requires !_WRITE_HAS_OCCURRED_$$outputArray$1 ==> _WRITE_SOURCE_$$outputArray$1 == 0bv32;
  requires !_READ_HAS_OCCURRED_$$outputArray$1 ==> _READ_SOURCE_$$outputArray$1 == 0bv32;
  requires _WRITE_HAS_OCCURRED_$$outputArray$1 ==> _WRITE_SOURCE_$$outputArray$1 == 6bv32 || _WRITE_SOURCE_$$outputArray$1 == 7bv32 || _WRITE_SOURCE_$$outputArray$1 == 8bv32 || _WRITE_SOURCE_$$outputArray$1 == 9bv32 || _WRITE_SOURCE_$$outputArray$1 == 13bv32 || _WRITE_SOURCE_$$outputArray$1 == 14bv32 || _WRITE_SOURCE_$$outputArray$1 == 15bv32 || _WRITE_SOURCE_$$outputArray$1 == 16bv32 || _WRITE_SOURCE_$$outputArray$1 == 20bv32 || _WRITE_SOURCE_$$outputArray$1 == 21bv32 || _WRITE_SOURCE_$$outputArray$1 == 22bv32 || _WRITE_SOURCE_$$outputArray$1 == 23bv32;
  requires _READ_HAS_OCCURRED_$$outputArray$1 ==> _READ_SOURCE_$$outputArray$1 == 3bv32 || _READ_SOURCE_$$outputArray$1 == 4bv32 || _READ_SOURCE_$$outputArray$1 == 5bv32 || _READ_SOURCE_$$outputArray$1 == 10bv32 || _READ_SOURCE_$$outputArray$1 == 11bv32 || _READ_SOURCE_$$outputArray$1 == 12bv32 || _READ_SOURCE_$$outputArray$1 == 17bv32 || _READ_SOURCE_$$outputArray$1 == 18bv32 || _READ_SOURCE_$$outputArray$1 == 19bv32;
  requires !_WRITE_HAS_OCCURRED_$$sortedArray$1 ==> _WRITE_SOURCE_$$sortedArray$1 == 0bv32;
  requires !_READ_HAS_OCCURRED_$$sortedArray$1 ==> _READ_SOURCE_$$sortedArray$1 == 0bv32;
  requires _WRITE_HAS_OCCURRED_$$sortedArray$1 ==> false;
  requires _READ_HAS_OCCURRED_$$sortedArray$1 ==> _READ_SOURCE_$$sortedArray$1 == 1bv32 || _READ_SOURCE_$$sortedArray$1 == 2bv32;
  requires group_id_x$1 == group_id_x$2 && group_id_y$1 == group_id_y$2 && group_id_z$1 == group_id_z$2 ==> local_id_x$1 != local_id_x$2 || local_id_y$1 != local_id_y$2 || local_id_z$1 != local_id_z$2;
  ensures !_WRITE_HAS_OCCURRED_$$outputArray$1 ==> _WRITE_SOURCE_$$outputArray$1 == 0bv32;
  ensures !_READ_HAS_OCCURRED_$$outputArray$1 ==> _READ_SOURCE_$$outputArray$1 == 0bv32;
  ensures _WRITE_HAS_OCCURRED_$$outputArray$1 ==> _WRITE_SOURCE_$$outputArray$1 == 6bv32 || _WRITE_SOURCE_$$outputArray$1 == 7bv32 || _WRITE_SOURCE_$$outputArray$1 == 8bv32 || _WRITE_SOURCE_$$outputArray$1 == 9bv32 || _WRITE_SOURCE_$$outputArray$1 == 13bv32 || _WRITE_SOURCE_$$outputArray$1 == 14bv32 || _WRITE_SOURCE_$$outputArray$1 == 15bv32 || _WRITE_SOURCE_$$outputArray$1 == 16bv32 || _WRITE_SOURCE_$$outputArray$1 == 20bv32 || _WRITE_SOURCE_$$outputArray$1 == 21bv32 || _WRITE_SOURCE_$$outputArray$1 == 22bv32 || _WRITE_SOURCE_$$outputArray$1 == 23bv32;
  ensures _READ_HAS_OCCURRED_$$outputArray$1 ==> _READ_SOURCE_$$outputArray$1 == 3bv32 || _READ_SOURCE_$$outputArray$1 == 4bv32 || _READ_SOURCE_$$outputArray$1 == 5bv32 || _READ_SOURCE_$$outputArray$1 == 10bv32 || _READ_SOURCE_$$outputArray$1 == 11bv32 || _READ_SOURCE_$$outputArray$1 == 12bv32 || _READ_SOURCE_$$outputArray$1 == 17bv32 || _READ_SOURCE_$$outputArray$1 == 18bv32 || _READ_SOURCE_$$outputArray$1 == 19bv32;
  ensures !_WRITE_HAS_OCCURRED_$$sortedArray$1 ==> _WRITE_SOURCE_$$sortedArray$1 == 0bv32;
  ensures !_READ_HAS_OCCURRED_$$sortedArray$1 ==> _READ_SOURCE_$$sortedArray$1 == 0bv32;
  ensures _WRITE_HAS_OCCURRED_$$sortedArray$1 ==> false;
  ensures _READ_HAS_OCCURRED_$$sortedArray$1 ==> _READ_SOURCE_$$sortedArray$1 == 1bv32 || _READ_SOURCE_$$sortedArray$1 == 2bv32;



implementation {:kernel} $binarySearch($findMe: bv32, $globalLowerBound: bv32, $globalUpperBound: bv32, $subdivSize: bv32)
{
  var v3$1: bv32;
  var v3$2: bv32;
  var v10$1: bv32;
  var v10$2: bv32;
  var v2$1: bv32;
  var v2$2: bv32;
  var v9$1: bv32;
  var v9$2: bv32;
  var v6$1: bv32;
  var v6$2: bv32;
  var v11$1: bv32;
  var v11$2: bv32;
  var v0$1: bv32;
  var v0$2: bv32;
  var v8$1: bv32;
  var v8$2: bv32;
  var v14$1: bv32;
  var v14$2: bv32;
  var v12$1: bv32;
  var v12$2: bv32;
  var v7$1: bv32;
  var v7$2: bv32;
  var v13$1: bv32;
  var v13$2: bv32;
  var v1$1: bv32;
  var v1$2: bv32;
  var v4$1: bool;
  var v4$2: bool;
  var v5$1: bool;
  var v5$2: bool;
  var p0$1: bool;
  var p0$2: bool;
  var p1$1: bool;
  var p1$2: bool;
  var p2$1: bool;
  var p2$2: bool;
  var p3$1: bool;
  var p3$2: bool;
  var p4$1: bool;
  var p4$2: bool;
  var _HAVOC_bv32$1: bv32;
  var _HAVOC_bv32$2: bv32;


  $0:
    v0$1 := BV32_ADD($globalLowerBound, BV32_MUL($subdivSize, BV32_ADD(BV32_MUL(group_size_x, group_id_x$1), local_id_x$1)));
    v0$2 := BV32_ADD($globalLowerBound, BV32_MUL($subdivSize, BV32_ADD(BV32_MUL(group_size_x, group_id_x$2), local_id_x$2)));
    v1$1 := BV32_SUB(BV32_ADD(v0$1, $subdivSize), 1bv32);
    v1$2 := BV32_SUB(BV32_ADD(v0$2, $subdivSize), 1bv32);
    assert {:sourceloc} {:line 139} {:col 61} {:fname "AMD_SDK\BinarySearch\gpuverify\kernel1/../common.cl"} {:dir "C:\prog\Papers\POPL2013\Experiments\ExperimantalDownload\unstructured\Benchmarks"} true;
    v2$1 := $$sortedArray[v0$1];
    v2$2 := $$sortedArray[v0$2];
    call _LOG_READ_$$sortedArray(true, v0$1, 1bv32);
    call {:sourceloc} {:line 139} {:col 61} {:fname "AMD_SDK\BinarySearch\gpuverify\kernel1/../common.cl"} {:dir "C:\prog\Papers\POPL2013\Experiments\ExperimantalDownload\unstructured\Benchmarks"} _CHECK_READ_$$sortedArray(true, v0$2);
    assert {:sourceloc} {:line 140} {:col 61} {:fname "AMD_SDK\BinarySearch\gpuverify\kernel1/../common.cl"} {:dir "C:\prog\Papers\POPL2013\Experiments\ExperimantalDownload\unstructured\Benchmarks"} true;
    v3$1 := $$sortedArray[v1$1];
    v3$2 := $$sortedArray[v1$2];
    call _LOG_READ_$$sortedArray(true, v1$1, 2bv32);
    call {:sourceloc} {:line 140} {:col 61} {:fname "AMD_SDK\BinarySearch\gpuverify\kernel1/../common.cl"} {:dir "C:\prog\Papers\POPL2013\Experiments\ExperimantalDownload\unstructured\Benchmarks"} _CHECK_READ_$$sortedArray(true, v1$2);
    v4$1 := BV32_UGT(v2$1, $findMe);
    v4$2 := BV32_UGT(v2$2, $findMe);
    p0$1 := false;
    p0$2 := false;
    p1$1 := false;
    p1$2 := false;
    p2$1 := false;
    p2$2 := false;
    p3$1 := false;
    p3$2 := false;
    p4$1 := false;
    p4$2 := false;
    p4$1 := v4$1;
    p4$2 := v4$2;
    p1$1 := !v4$1;
    p1$2 := !v4$2;
    goto $truebb;

  $truebb:
    p4$1 := (if p0$1 then true else p4$1);
    p4$2 := (if p0$2 then true else p4$2);
    v5$1 := (if p1$1 then BV32_ULT(v3$1, $findMe) else v5$1);
    v5$2 := (if p1$2 then BV32_ULT(v3$2, $findMe) else v5$2);
    p4$1 := (if p1$1 then v5$1 else p4$1);
    p4$2 := (if p1$2 then v5$2 else p4$2);
    p3$1 := (if p1$1 then !v5$1 else p3$1);
    p3$2 := (if p1$2 then !v5$2 else p3$2);
    p4$1 := (if p2$1 then true else p4$1);
    p4$2 := (if p2$2 then true else p4$2);
    assert {:sourceloc} {:line 154} {:col 9} {:fname "AMD_SDK\BinarySearch\gpuverify\kernel1/../common.cl"} {:dir "C:\prog\Papers\POPL2013\Experiments\ExperimantalDownload\unstructured\Benchmarks"} p3$1 ==> true;
    havoc _HAVOC_bv32$1, _HAVOC_bv32$2;
    v6$1 := (if p3$1 then _HAVOC_bv32$1 else v6$1);
    v6$2 := (if p3$2 then _HAVOC_bv32$2 else v6$2);
    call _LOG_READ_$$outputArray(p3$1, 1bv32, 3bv32);
    call {:sourceloc} {:line 154} {:col 9} {:fname "AMD_SDK\BinarySearch\gpuverify\kernel1/../common.cl"} {:dir "C:\prog\Papers\POPL2013\Experiments\ExperimantalDownload\unstructured\Benchmarks"} _CHECK_READ_$$outputArray(p3$2, 1bv32);
    assert {:sourceloc} {:line 154} {:col 9} {:fname "AMD_SDK\BinarySearch\gpuverify\kernel1/../common.cl"} {:dir "C:\prog\Papers\POPL2013\Experiments\ExperimantalDownload\unstructured\Benchmarks"} p3$1 ==> true;
    havoc _HAVOC_bv32$1, _HAVOC_bv32$2;
    v7$1 := (if p3$1 then _HAVOC_bv32$1 else v7$1);
    v7$2 := (if p3$2 then _HAVOC_bv32$2 else v7$2);
    call _LOG_READ_$$outputArray(p3$1, 2bv32, 4bv32);
    call {:sourceloc} {:line 154} {:col 9} {:fname "AMD_SDK\BinarySearch\gpuverify\kernel1/../common.cl"} {:dir "C:\prog\Papers\POPL2013\Experiments\ExperimantalDownload\unstructured\Benchmarks"} _CHECK_READ_$$outputArray(p3$2, 2bv32);
    assert {:sourceloc} {:line 154} {:col 9} {:fname "AMD_SDK\BinarySearch\gpuverify\kernel1/../common.cl"} {:dir "C:\prog\Papers\POPL2013\Experiments\ExperimantalDownload\unstructured\Benchmarks"} p3$1 ==> true;
    havoc _HAVOC_bv32$1, _HAVOC_bv32$2;
    v8$1 := (if p3$1 then _HAVOC_bv32$1 else v8$1);
    v8$2 := (if p3$2 then _HAVOC_bv32$2 else v8$2);
    call _LOG_READ_$$outputArray(p3$1, 3bv32, 5bv32);
    call {:sourceloc} {:line 154} {:col 9} {:fname "AMD_SDK\BinarySearch\gpuverify\kernel1/../common.cl"} {:dir "C:\prog\Papers\POPL2013\Experiments\ExperimantalDownload\unstructured\Benchmarks"} _CHECK_READ_$$outputArray(p3$2, 3bv32);
    assert {:sourceloc} {:line 154} {:col 9} {:fname "AMD_SDK\BinarySearch\gpuverify\kernel1/../common.cl"} {:dir "C:\prog\Papers\POPL2013\Experiments\ExperimantalDownload\unstructured\Benchmarks"} p3$1 ==> true;
    call _LOG_WRITE_$$outputArray(p3$1, 0bv32, 6bv32);
    call {:sourceloc} {:line 154} {:col 9} {:fname "AMD_SDK\BinarySearch\gpuverify\kernel1/../common.cl"} {:dir "C:\prog\Papers\POPL2013\Experiments\ExperimantalDownload\unstructured\Benchmarks"} _CHECK_WRITE_$$outputArray(p3$2, 0bv32);
    assert {:sourceloc} {:line 154} {:col 9} {:fname "AMD_SDK\BinarySearch\gpuverify\kernel1/../common.cl"} {:dir "C:\prog\Papers\POPL2013\Experiments\ExperimantalDownload\unstructured\Benchmarks"} p3$1 ==> true;
    call _LOG_WRITE_$$outputArray(p3$1, 1bv32, 7bv32);
    call {:sourceloc} {:line 154} {:col 9} {:fname "AMD_SDK\BinarySearch\gpuverify\kernel1/../common.cl"} {:dir "C:\prog\Papers\POPL2013\Experiments\ExperimantalDownload\unstructured\Benchmarks"} _CHECK_WRITE_$$outputArray(p3$2, 1bv32);
    assert {:sourceloc} {:line 154} {:col 9} {:fname "AMD_SDK\BinarySearch\gpuverify\kernel1/../common.cl"} {:dir "C:\prog\Papers\POPL2013\Experiments\ExperimantalDownload\unstructured\Benchmarks"} p3$1 ==> true;
    call _LOG_WRITE_$$outputArray(p3$1, 2bv32, 8bv32);
    call {:sourceloc} {:line 154} {:col 9} {:fname "AMD_SDK\BinarySearch\gpuverify\kernel1/../common.cl"} {:dir "C:\prog\Papers\POPL2013\Experiments\ExperimantalDownload\unstructured\Benchmarks"} _CHECK_WRITE_$$outputArray(p3$2, 2bv32);
    assert {:sourceloc} {:line 154} {:col 9} {:fname "AMD_SDK\BinarySearch\gpuverify\kernel1/../common.cl"} {:dir "C:\prog\Papers\POPL2013\Experiments\ExperimantalDownload\unstructured\Benchmarks"} p3$1 ==> true;
    call _LOG_WRITE_$$outputArray(p3$1, 3bv32, 9bv32);
    call {:sourceloc} {:line 154} {:col 9} {:fname "AMD_SDK\BinarySearch\gpuverify\kernel1/../common.cl"} {:dir "C:\prog\Papers\POPL2013\Experiments\ExperimantalDownload\unstructured\Benchmarks"} _CHECK_WRITE_$$outputArray(p3$2, 3bv32);
    assert {:sourceloc} {:line 155} {:col 9} {:fname "AMD_SDK\BinarySearch\gpuverify\kernel1/../common.cl"} {:dir "C:\prog\Papers\POPL2013\Experiments\ExperimantalDownload\unstructured\Benchmarks"} p3$1 ==> true;
    havoc _HAVOC_bv32$1, _HAVOC_bv32$2;
    v9$1 := (if p3$1 then _HAVOC_bv32$1 else v9$1);
    v9$2 := (if p3$2 then _HAVOC_bv32$2 else v9$2);
    call _LOG_READ_$$outputArray(p3$1, 0bv32, 10bv32);
    call {:sourceloc} {:line 155} {:col 9} {:fname "AMD_SDK\BinarySearch\gpuverify\kernel1/../common.cl"} {:dir "C:\prog\Papers\POPL2013\Experiments\ExperimantalDownload\unstructured\Benchmarks"} _CHECK_READ_$$outputArray(p3$2, 0bv32);
    assert {:sourceloc} {:line 155} {:col 9} {:fname "AMD_SDK\BinarySearch\gpuverify\kernel1/../common.cl"} {:dir "C:\prog\Papers\POPL2013\Experiments\ExperimantalDownload\unstructured\Benchmarks"} p3$1 ==> true;
    havoc _HAVOC_bv32$1, _HAVOC_bv32$2;
    v10$1 := (if p3$1 then _HAVOC_bv32$1 else v10$1);
    v10$2 := (if p3$2 then _HAVOC_bv32$2 else v10$2);
    call _LOG_READ_$$outputArray(p3$1, 2bv32, 11bv32);
    call {:sourceloc} {:line 155} {:col 9} {:fname "AMD_SDK\BinarySearch\gpuverify\kernel1/../common.cl"} {:dir "C:\prog\Papers\POPL2013\Experiments\ExperimantalDownload\unstructured\Benchmarks"} _CHECK_READ_$$outputArray(p3$2, 2bv32);
    assert {:sourceloc} {:line 155} {:col 9} {:fname "AMD_SDK\BinarySearch\gpuverify\kernel1/../common.cl"} {:dir "C:\prog\Papers\POPL2013\Experiments\ExperimantalDownload\unstructured\Benchmarks"} p3$1 ==> true;
    havoc _HAVOC_bv32$1, _HAVOC_bv32$2;
    v11$1 := (if p3$1 then _HAVOC_bv32$1 else v11$1);
    v11$2 := (if p3$2 then _HAVOC_bv32$2 else v11$2);
    call _LOG_READ_$$outputArray(p3$1, 3bv32, 12bv32);
    call {:sourceloc} {:line 155} {:col 9} {:fname "AMD_SDK\BinarySearch\gpuverify\kernel1/../common.cl"} {:dir "C:\prog\Papers\POPL2013\Experiments\ExperimantalDownload\unstructured\Benchmarks"} _CHECK_READ_$$outputArray(p3$2, 3bv32);
    assert {:sourceloc} {:line 155} {:col 9} {:fname "AMD_SDK\BinarySearch\gpuverify\kernel1/../common.cl"} {:dir "C:\prog\Papers\POPL2013\Experiments\ExperimantalDownload\unstructured\Benchmarks"} p3$1 ==> true;
    call _LOG_WRITE_$$outputArray(p3$1, 0bv32, 13bv32);
    call {:sourceloc} {:line 155} {:col 9} {:fname "AMD_SDK\BinarySearch\gpuverify\kernel1/../common.cl"} {:dir "C:\prog\Papers\POPL2013\Experiments\ExperimantalDownload\unstructured\Benchmarks"} _CHECK_WRITE_$$outputArray(p3$2, 0bv32);
    assert {:sourceloc} {:line 155} {:col 9} {:fname "AMD_SDK\BinarySearch\gpuverify\kernel1/../common.cl"} {:dir "C:\prog\Papers\POPL2013\Experiments\ExperimantalDownload\unstructured\Benchmarks"} p3$1 ==> true;
    call _LOG_WRITE_$$outputArray(p3$1, 1bv32, 14bv32);
    call {:sourceloc} {:line 155} {:col 9} {:fname "AMD_SDK\BinarySearch\gpuverify\kernel1/../common.cl"} {:dir "C:\prog\Papers\POPL2013\Experiments\ExperimantalDownload\unstructured\Benchmarks"} _CHECK_WRITE_$$outputArray(p3$2, 1bv32);
    assert {:sourceloc} {:line 155} {:col 9} {:fname "AMD_SDK\BinarySearch\gpuverify\kernel1/../common.cl"} {:dir "C:\prog\Papers\POPL2013\Experiments\ExperimantalDownload\unstructured\Benchmarks"} p3$1 ==> true;
    call _LOG_WRITE_$$outputArray(p3$1, 2bv32, 15bv32);
    call {:sourceloc} {:line 155} {:col 9} {:fname "AMD_SDK\BinarySearch\gpuverify\kernel1/../common.cl"} {:dir "C:\prog\Papers\POPL2013\Experiments\ExperimantalDownload\unstructured\Benchmarks"} _CHECK_WRITE_$$outputArray(p3$2, 2bv32);
    assert {:sourceloc} {:line 155} {:col 9} {:fname "AMD_SDK\BinarySearch\gpuverify\kernel1/../common.cl"} {:dir "C:\prog\Papers\POPL2013\Experiments\ExperimantalDownload\unstructured\Benchmarks"} p3$1 ==> true;
    call _LOG_WRITE_$$outputArray(p3$1, 3bv32, 16bv32);
    call {:sourceloc} {:line 155} {:col 9} {:fname "AMD_SDK\BinarySearch\gpuverify\kernel1/../common.cl"} {:dir "C:\prog\Papers\POPL2013\Experiments\ExperimantalDownload\unstructured\Benchmarks"} _CHECK_WRITE_$$outputArray(p3$2, 3bv32);
    assert {:sourceloc} {:line 156} {:col 9} {:fname "AMD_SDK\BinarySearch\gpuverify\kernel1/../common.cl"} {:dir "C:\prog\Papers\POPL2013\Experiments\ExperimantalDownload\unstructured\Benchmarks"} p3$1 ==> true;
    havoc _HAVOC_bv32$1, _HAVOC_bv32$2;
    v12$1 := (if p3$1 then _HAVOC_bv32$1 else v12$1);
    v12$2 := (if p3$2 then _HAVOC_bv32$2 else v12$2);
    call _LOG_READ_$$outputArray(p3$1, 0bv32, 17bv32);
    call {:sourceloc} {:line 156} {:col 9} {:fname "AMD_SDK\BinarySearch\gpuverify\kernel1/../common.cl"} {:dir "C:\prog\Papers\POPL2013\Experiments\ExperimantalDownload\unstructured\Benchmarks"} _CHECK_READ_$$outputArray(p3$2, 0bv32);
    assert {:sourceloc} {:line 156} {:col 9} {:fname "AMD_SDK\BinarySearch\gpuverify\kernel1/../common.cl"} {:dir "C:\prog\Papers\POPL2013\Experiments\ExperimantalDownload\unstructured\Benchmarks"} p3$1 ==> true;
    havoc _HAVOC_bv32$1, _HAVOC_bv32$2;
    v13$1 := (if p3$1 then _HAVOC_bv32$1 else v13$1);
    v13$2 := (if p3$2 then _HAVOC_bv32$2 else v13$2);
    call _LOG_READ_$$outputArray(p3$1, 1bv32, 18bv32);
    call {:sourceloc} {:line 156} {:col 9} {:fname "AMD_SDK\BinarySearch\gpuverify\kernel1/../common.cl"} {:dir "C:\prog\Papers\POPL2013\Experiments\ExperimantalDownload\unstructured\Benchmarks"} _CHECK_READ_$$outputArray(p3$2, 1bv32);
    assert {:sourceloc} {:line 156} {:col 9} {:fname "AMD_SDK\BinarySearch\gpuverify\kernel1/../common.cl"} {:dir "C:\prog\Papers\POPL2013\Experiments\ExperimantalDownload\unstructured\Benchmarks"} p3$1 ==> true;
    havoc _HAVOC_bv32$1, _HAVOC_bv32$2;
    v14$1 := (if p3$1 then _HAVOC_bv32$1 else v14$1);
    v14$2 := (if p3$2 then _HAVOC_bv32$2 else v14$2);
    call _LOG_READ_$$outputArray(p3$1, 2bv32, 19bv32);
    call {:sourceloc} {:line 156} {:col 9} {:fname "AMD_SDK\BinarySearch\gpuverify\kernel1/../common.cl"} {:dir "C:\prog\Papers\POPL2013\Experiments\ExperimantalDownload\unstructured\Benchmarks"} _CHECK_READ_$$outputArray(p3$2, 2bv32);
    assert {:sourceloc} {:line 156} {:col 9} {:fname "AMD_SDK\BinarySearch\gpuverify\kernel1/../common.cl"} {:dir "C:\prog\Papers\POPL2013\Experiments\ExperimantalDownload\unstructured\Benchmarks"} p3$1 ==> true;
    call _LOG_WRITE_$$outputArray(p3$1, 0bv32, 20bv32);
    call {:sourceloc} {:line 156} {:col 9} {:fname "AMD_SDK\BinarySearch\gpuverify\kernel1/../common.cl"} {:dir "C:\prog\Papers\POPL2013\Experiments\ExperimantalDownload\unstructured\Benchmarks"} _CHECK_WRITE_$$outputArray(p3$2, 0bv32);
    assert {:sourceloc} {:line 156} {:col 9} {:fname "AMD_SDK\BinarySearch\gpuverify\kernel1/../common.cl"} {:dir "C:\prog\Papers\POPL2013\Experiments\ExperimantalDownload\unstructured\Benchmarks"} p3$1 ==> true;
    call _LOG_WRITE_$$outputArray(p3$1, 1bv32, 21bv32);
    call {:sourceloc} {:line 156} {:col 9} {:fname "AMD_SDK\BinarySearch\gpuverify\kernel1/../common.cl"} {:dir "C:\prog\Papers\POPL2013\Experiments\ExperimantalDownload\unstructured\Benchmarks"} _CHECK_WRITE_$$outputArray(p3$2, 1bv32);
    assert {:sourceloc} {:line 156} {:col 9} {:fname "AMD_SDK\BinarySearch\gpuverify\kernel1/../common.cl"} {:dir "C:\prog\Papers\POPL2013\Experiments\ExperimantalDownload\unstructured\Benchmarks"} p3$1 ==> true;
    call _LOG_WRITE_$$outputArray(p3$1, 2bv32, 22bv32);
    call {:sourceloc} {:line 156} {:col 9} {:fname "AMD_SDK\BinarySearch\gpuverify\kernel1/../common.cl"} {:dir "C:\prog\Papers\POPL2013\Experiments\ExperimantalDownload\unstructured\Benchmarks"} _CHECK_WRITE_$$outputArray(p3$2, 2bv32);
    assert {:sourceloc} {:line 156} {:col 9} {:fname "AMD_SDK\BinarySearch\gpuverify\kernel1/../common.cl"} {:dir "C:\prog\Papers\POPL2013\Experiments\ExperimantalDownload\unstructured\Benchmarks"} p3$1 ==> true;
    call _LOG_WRITE_$$outputArray(p3$1, 3bv32, 23bv32);
    call {:sourceloc} {:line 156} {:col 9} {:fname "AMD_SDK\BinarySearch\gpuverify\kernel1/../common.cl"} {:dir "C:\prog\Papers\POPL2013\Experiments\ExperimantalDownload\unstructured\Benchmarks"} _CHECK_WRITE_$$outputArray(p3$2, 3bv32);
    goto $4;

  $4:
    return;
}



axiom (if group_size_y == 1bv32 then 1bv1 else 0bv1) != 0bv1;

axiom (if group_size_z == 1bv32 then 1bv1 else 0bv1) != 0bv1;

axiom (if num_groups_y == 1bv32 then 1bv1 else 0bv1) != 0bv1;

axiom (if num_groups_z == 1bv32 then 1bv1 else 0bv1) != 0bv1;

axiom (if group_size_x == 256bv32 then 1bv1 else 0bv1) != 0bv1;

axiom (if num_groups_x == 2bv32 then 1bv1 else 0bv1) != 0bv1;

procedure {:inline 1} {:barrier} barrier(__local_fence: bv1, __global_fence: bv1);
  requires {:barrier_divergence} group_id_x$1 == group_id_x$2 && group_id_y$1 == group_id_y$2 && group_id_z$1 == group_id_z$2 ==> true == true;
  requires !_WRITE_HAS_OCCURRED_$$outputArray$1 ==> _WRITE_SOURCE_$$outputArray$1 == 0bv32;
  requires !_READ_HAS_OCCURRED_$$outputArray$1 ==> _READ_SOURCE_$$outputArray$1 == 0bv32;
  requires _WRITE_HAS_OCCURRED_$$outputArray$1 ==> _WRITE_SOURCE_$$outputArray$1 == 6bv32 || _WRITE_SOURCE_$$outputArray$1 == 7bv32 || _WRITE_SOURCE_$$outputArray$1 == 8bv32 || _WRITE_SOURCE_$$outputArray$1 == 9bv32 || _WRITE_SOURCE_$$outputArray$1 == 13bv32 || _WRITE_SOURCE_$$outputArray$1 == 14bv32 || _WRITE_SOURCE_$$outputArray$1 == 15bv32 || _WRITE_SOURCE_$$outputArray$1 == 16bv32 || _WRITE_SOURCE_$$outputArray$1 == 20bv32 || _WRITE_SOURCE_$$outputArray$1 == 21bv32 || _WRITE_SOURCE_$$outputArray$1 == 22bv32 || _WRITE_SOURCE_$$outputArray$1 == 23bv32;
  requires _READ_HAS_OCCURRED_$$outputArray$1 ==> _READ_SOURCE_$$outputArray$1 == 3bv32 || _READ_SOURCE_$$outputArray$1 == 4bv32 || _READ_SOURCE_$$outputArray$1 == 5bv32 || _READ_SOURCE_$$outputArray$1 == 10bv32 || _READ_SOURCE_$$outputArray$1 == 11bv32 || _READ_SOURCE_$$outputArray$1 == 12bv32 || _READ_SOURCE_$$outputArray$1 == 17bv32 || _READ_SOURCE_$$outputArray$1 == 18bv32 || _READ_SOURCE_$$outputArray$1 == 19bv32;
  requires !_WRITE_HAS_OCCURRED_$$sortedArray$1 ==> _WRITE_SOURCE_$$sortedArray$1 == 0bv32;
  requires !_READ_HAS_OCCURRED_$$sortedArray$1 ==> _READ_SOURCE_$$sortedArray$1 == 0bv32;
  requires _WRITE_HAS_OCCURRED_$$sortedArray$1 ==> false;
  requires _READ_HAS_OCCURRED_$$sortedArray$1 ==> _READ_SOURCE_$$sortedArray$1 == 1bv32 || _READ_SOURCE_$$sortedArray$1 == 2bv32;
  ensures !_WRITE_HAS_OCCURRED_$$outputArray$1 ==> _WRITE_SOURCE_$$outputArray$1 == 0bv32;
  ensures !_READ_HAS_OCCURRED_$$outputArray$1 ==> _READ_SOURCE_$$outputArray$1 == 0bv32;
  ensures _WRITE_HAS_OCCURRED_$$outputArray$1 ==> _WRITE_SOURCE_$$outputArray$1 == 6bv32 || _WRITE_SOURCE_$$outputArray$1 == 7bv32 || _WRITE_SOURCE_$$outputArray$1 == 8bv32 || _WRITE_SOURCE_$$outputArray$1 == 9bv32 || _WRITE_SOURCE_$$outputArray$1 == 13bv32 || _WRITE_SOURCE_$$outputArray$1 == 14bv32 || _WRITE_SOURCE_$$outputArray$1 == 15bv32 || _WRITE_SOURCE_$$outputArray$1 == 16bv32 || _WRITE_SOURCE_$$outputArray$1 == 20bv32 || _WRITE_SOURCE_$$outputArray$1 == 21bv32 || _WRITE_SOURCE_$$outputArray$1 == 22bv32 || _WRITE_SOURCE_$$outputArray$1 == 23bv32;
  ensures _READ_HAS_OCCURRED_$$outputArray$1 ==> _READ_SOURCE_$$outputArray$1 == 3bv32 || _READ_SOURCE_$$outputArray$1 == 4bv32 || _READ_SOURCE_$$outputArray$1 == 5bv32 || _READ_SOURCE_$$outputArray$1 == 10bv32 || _READ_SOURCE_$$outputArray$1 == 11bv32 || _READ_SOURCE_$$outputArray$1 == 12bv32 || _READ_SOURCE_$$outputArray$1 == 17bv32 || _READ_SOURCE_$$outputArray$1 == 18bv32 || _READ_SOURCE_$$outputArray$1 == 19bv32;
  ensures !_WRITE_HAS_OCCURRED_$$sortedArray$1 ==> _WRITE_SOURCE_$$sortedArray$1 == 0bv32;
  ensures !_READ_HAS_OCCURRED_$$sortedArray$1 ==> _READ_SOURCE_$$sortedArray$1 == 0bv32;
  ensures _WRITE_HAS_OCCURRED_$$sortedArray$1 ==> false;
  ensures _READ_HAS_OCCURRED_$$sortedArray$1 ==> _READ_SOURCE_$$sortedArray$1 == 1bv32 || _READ_SOURCE_$$sortedArray$1 == 2bv32;



const {:local_id_y} local_id_y$1: bv32;

const {:local_id_y} local_id_y$2: bv32;

const {:local_id_z} local_id_z$1: bv32;

const {:local_id_z} local_id_z$2: bv32;

const {:group_id_y} group_id_y$1: bv32;

const {:group_id_y} group_id_y$2: bv32;

const {:group_id_z} group_id_z$1: bv32;

const {:group_id_z} group_id_z$2: bv32;

var _READ_SOURCE_$$outputArray$1: bv32;

var _WRITE_SOURCE_$$outputArray$1: bv32;

procedure {:inline 1} _LOG_READ_$$outputArray(_P$1: bool, _offset$1: bv32, _source$1: bv32);
  requires !_WRITE_HAS_OCCURRED_$$outputArray$1 ==> _WRITE_SOURCE_$$outputArray$1 == 0bv32;
  requires !_READ_HAS_OCCURRED_$$outputArray$1 ==> _READ_SOURCE_$$outputArray$1 == 0bv32;
  requires _WRITE_HAS_OCCURRED_$$outputArray$1 ==> _WRITE_SOURCE_$$outputArray$1 == 6bv32 || _WRITE_SOURCE_$$outputArray$1 == 7bv32 || _WRITE_SOURCE_$$outputArray$1 == 8bv32 || _WRITE_SOURCE_$$outputArray$1 == 9bv32 || _WRITE_SOURCE_$$outputArray$1 == 13bv32 || _WRITE_SOURCE_$$outputArray$1 == 14bv32 || _WRITE_SOURCE_$$outputArray$1 == 15bv32 || _WRITE_SOURCE_$$outputArray$1 == 16bv32 || _WRITE_SOURCE_$$outputArray$1 == 20bv32 || _WRITE_SOURCE_$$outputArray$1 == 21bv32 || _WRITE_SOURCE_$$outputArray$1 == 22bv32 || _WRITE_SOURCE_$$outputArray$1 == 23bv32;
  requires _READ_HAS_OCCURRED_$$outputArray$1 ==> _READ_SOURCE_$$outputArray$1 == 3bv32 || _READ_SOURCE_$$outputArray$1 == 4bv32 || _READ_SOURCE_$$outputArray$1 == 5bv32 || _READ_SOURCE_$$outputArray$1 == 10bv32 || _READ_SOURCE_$$outputArray$1 == 11bv32 || _READ_SOURCE_$$outputArray$1 == 12bv32 || _READ_SOURCE_$$outputArray$1 == 17bv32 || _READ_SOURCE_$$outputArray$1 == 18bv32 || _READ_SOURCE_$$outputArray$1 == 19bv32;
  requires !_WRITE_HAS_OCCURRED_$$sortedArray$1 ==> _WRITE_SOURCE_$$sortedArray$1 == 0bv32;
  requires !_READ_HAS_OCCURRED_$$sortedArray$1 ==> _READ_SOURCE_$$sortedArray$1 == 0bv32;
  requires _WRITE_HAS_OCCURRED_$$sortedArray$1 ==> false;
  requires _READ_HAS_OCCURRED_$$sortedArray$1 ==> _READ_SOURCE_$$sortedArray$1 == 1bv32 || _READ_SOURCE_$$sortedArray$1 == 2bv32;
  modifies _READ_HAS_OCCURRED_$$outputArray$1, _READ_OFFSET_$$outputArray$1;
  ensures !_WRITE_HAS_OCCURRED_$$outputArray$1 ==> _WRITE_SOURCE_$$outputArray$1 == 0bv32;
  ensures !_READ_HAS_OCCURRED_$$outputArray$1 ==> _READ_SOURCE_$$outputArray$1 == 0bv32;
  ensures _WRITE_HAS_OCCURRED_$$outputArray$1 ==> _WRITE_SOURCE_$$outputArray$1 == 6bv32 || _WRITE_SOURCE_$$outputArray$1 == 7bv32 || _WRITE_SOURCE_$$outputArray$1 == 8bv32 || _WRITE_SOURCE_$$outputArray$1 == 9bv32 || _WRITE_SOURCE_$$outputArray$1 == 13bv32 || _WRITE_SOURCE_$$outputArray$1 == 14bv32 || _WRITE_SOURCE_$$outputArray$1 == 15bv32 || _WRITE_SOURCE_$$outputArray$1 == 16bv32 || _WRITE_SOURCE_$$outputArray$1 == 20bv32 || _WRITE_SOURCE_$$outputArray$1 == 21bv32 || _WRITE_SOURCE_$$outputArray$1 == 22bv32 || _WRITE_SOURCE_$$outputArray$1 == 23bv32;
  ensures _READ_HAS_OCCURRED_$$outputArray$1 ==> _READ_SOURCE_$$outputArray$1 == 3bv32 || _READ_SOURCE_$$outputArray$1 == 4bv32 || _READ_SOURCE_$$outputArray$1 == 5bv32 || _READ_SOURCE_$$outputArray$1 == 10bv32 || _READ_SOURCE_$$outputArray$1 == 11bv32 || _READ_SOURCE_$$outputArray$1 == 12bv32 || _READ_SOURCE_$$outputArray$1 == 17bv32 || _READ_SOURCE_$$outputArray$1 == 18bv32 || _READ_SOURCE_$$outputArray$1 == 19bv32;
  ensures !_WRITE_HAS_OCCURRED_$$sortedArray$1 ==> _WRITE_SOURCE_$$sortedArray$1 == 0bv32;
  ensures !_READ_HAS_OCCURRED_$$sortedArray$1 ==> _READ_SOURCE_$$sortedArray$1 == 0bv32;
  ensures _WRITE_HAS_OCCURRED_$$sortedArray$1 ==> false;
  ensures _READ_HAS_OCCURRED_$$sortedArray$1 ==> _READ_SOURCE_$$sortedArray$1 == 1bv32 || _READ_SOURCE_$$sortedArray$1 == 2bv32;



implementation {:inline 1} _LOG_READ_$$outputArray(_P$1: bool, _offset$1: bv32, _source$1: bv32)
{
  var track: bool;


  _LOG_READ:
    havoc track;
    _READ_HAS_OCCURRED_$$outputArray$1 := (if _P$1 && track then true else _READ_HAS_OCCURRED_$$outputArray$1);
    _READ_OFFSET_$$outputArray$1 := (if _P$1 && track then _offset$1 else _READ_OFFSET_$$outputArray$1);
    _READ_SOURCE_$$outputArray$1 := (if _P$1 && track then _source$1 else _READ_SOURCE_$$outputArray$1);
    return;
}



procedure {:inline 1} _CHECK_READ_$$outputArray(_P$2: bool, _offset$2: bv32);
  requires {:race} {:write_read} !(_P$2 && _WRITE_HAS_OCCURRED_$$outputArray$1 && _WRITE_OFFSET_$$outputArray$1 == _offset$2);
  requires !_WRITE_HAS_OCCURRED_$$outputArray$1 ==> _WRITE_SOURCE_$$outputArray$1 == 0bv32;
  requires !_READ_HAS_OCCURRED_$$outputArray$1 ==> _READ_SOURCE_$$outputArray$1 == 0bv32;
  requires _WRITE_HAS_OCCURRED_$$outputArray$1 ==> _WRITE_SOURCE_$$outputArray$1 == 6bv32 || _WRITE_SOURCE_$$outputArray$1 == 7bv32 || _WRITE_SOURCE_$$outputArray$1 == 8bv32 || _WRITE_SOURCE_$$outputArray$1 == 9bv32 || _WRITE_SOURCE_$$outputArray$1 == 13bv32 || _WRITE_SOURCE_$$outputArray$1 == 14bv32 || _WRITE_SOURCE_$$outputArray$1 == 15bv32 || _WRITE_SOURCE_$$outputArray$1 == 16bv32 || _WRITE_SOURCE_$$outputArray$1 == 20bv32 || _WRITE_SOURCE_$$outputArray$1 == 21bv32 || _WRITE_SOURCE_$$outputArray$1 == 22bv32 || _WRITE_SOURCE_$$outputArray$1 == 23bv32;
  requires _READ_HAS_OCCURRED_$$outputArray$1 ==> _READ_SOURCE_$$outputArray$1 == 3bv32 || _READ_SOURCE_$$outputArray$1 == 4bv32 || _READ_SOURCE_$$outputArray$1 == 5bv32 || _READ_SOURCE_$$outputArray$1 == 10bv32 || _READ_SOURCE_$$outputArray$1 == 11bv32 || _READ_SOURCE_$$outputArray$1 == 12bv32 || _READ_SOURCE_$$outputArray$1 == 17bv32 || _READ_SOURCE_$$outputArray$1 == 18bv32 || _READ_SOURCE_$$outputArray$1 == 19bv32;
  requires !_WRITE_HAS_OCCURRED_$$sortedArray$1 ==> _WRITE_SOURCE_$$sortedArray$1 == 0bv32;
  requires !_READ_HAS_OCCURRED_$$sortedArray$1 ==> _READ_SOURCE_$$sortedArray$1 == 0bv32;
  requires _WRITE_HAS_OCCURRED_$$sortedArray$1 ==> false;
  requires _READ_HAS_OCCURRED_$$sortedArray$1 ==> _READ_SOURCE_$$sortedArray$1 == 1bv32 || _READ_SOURCE_$$sortedArray$1 == 2bv32;
  ensures !_WRITE_HAS_OCCURRED_$$outputArray$1 ==> _WRITE_SOURCE_$$outputArray$1 == 0bv32;
  ensures !_READ_HAS_OCCURRED_$$outputArray$1 ==> _READ_SOURCE_$$outputArray$1 == 0bv32;
  ensures _WRITE_HAS_OCCURRED_$$outputArray$1 ==> _WRITE_SOURCE_$$outputArray$1 == 6bv32 || _WRITE_SOURCE_$$outputArray$1 == 7bv32 || _WRITE_SOURCE_$$outputArray$1 == 8bv32 || _WRITE_SOURCE_$$outputArray$1 == 9bv32 || _WRITE_SOURCE_$$outputArray$1 == 13bv32 || _WRITE_SOURCE_$$outputArray$1 == 14bv32 || _WRITE_SOURCE_$$outputArray$1 == 15bv32 || _WRITE_SOURCE_$$outputArray$1 == 16bv32 || _WRITE_SOURCE_$$outputArray$1 == 20bv32 || _WRITE_SOURCE_$$outputArray$1 == 21bv32 || _WRITE_SOURCE_$$outputArray$1 == 22bv32 || _WRITE_SOURCE_$$outputArray$1 == 23bv32;
  ensures _READ_HAS_OCCURRED_$$outputArray$1 ==> _READ_SOURCE_$$outputArray$1 == 3bv32 || _READ_SOURCE_$$outputArray$1 == 4bv32 || _READ_SOURCE_$$outputArray$1 == 5bv32 || _READ_SOURCE_$$outputArray$1 == 10bv32 || _READ_SOURCE_$$outputArray$1 == 11bv32 || _READ_SOURCE_$$outputArray$1 == 12bv32 || _READ_SOURCE_$$outputArray$1 == 17bv32 || _READ_SOURCE_$$outputArray$1 == 18bv32 || _READ_SOURCE_$$outputArray$1 == 19bv32;
  ensures !_WRITE_HAS_OCCURRED_$$sortedArray$1 ==> _WRITE_SOURCE_$$sortedArray$1 == 0bv32;
  ensures !_READ_HAS_OCCURRED_$$sortedArray$1 ==> _READ_SOURCE_$$sortedArray$1 == 0bv32;
  ensures _WRITE_HAS_OCCURRED_$$sortedArray$1 ==> false;
  ensures _READ_HAS_OCCURRED_$$sortedArray$1 ==> _READ_SOURCE_$$sortedArray$1 == 1bv32 || _READ_SOURCE_$$sortedArray$1 == 2bv32;



procedure {:inline 1} _LOG_WRITE_$$outputArray(_P$1: bool, _offset$1: bv32, _source$1: bv32);
  requires !_WRITE_HAS_OCCURRED_$$outputArray$1 ==> _WRITE_SOURCE_$$outputArray$1 == 0bv32;
  requires !_READ_HAS_OCCURRED_$$outputArray$1 ==> _READ_SOURCE_$$outputArray$1 == 0bv32;
  requires _WRITE_HAS_OCCURRED_$$outputArray$1 ==> _WRITE_SOURCE_$$outputArray$1 == 6bv32 || _WRITE_SOURCE_$$outputArray$1 == 7bv32 || _WRITE_SOURCE_$$outputArray$1 == 8bv32 || _WRITE_SOURCE_$$outputArray$1 == 9bv32 || _WRITE_SOURCE_$$outputArray$1 == 13bv32 || _WRITE_SOURCE_$$outputArray$1 == 14bv32 || _WRITE_SOURCE_$$outputArray$1 == 15bv32 || _WRITE_SOURCE_$$outputArray$1 == 16bv32 || _WRITE_SOURCE_$$outputArray$1 == 20bv32 || _WRITE_SOURCE_$$outputArray$1 == 21bv32 || _WRITE_SOURCE_$$outputArray$1 == 22bv32 || _WRITE_SOURCE_$$outputArray$1 == 23bv32;
  requires _READ_HAS_OCCURRED_$$outputArray$1 ==> _READ_SOURCE_$$outputArray$1 == 3bv32 || _READ_SOURCE_$$outputArray$1 == 4bv32 || _READ_SOURCE_$$outputArray$1 == 5bv32 || _READ_SOURCE_$$outputArray$1 == 10bv32 || _READ_SOURCE_$$outputArray$1 == 11bv32 || _READ_SOURCE_$$outputArray$1 == 12bv32 || _READ_SOURCE_$$outputArray$1 == 17bv32 || _READ_SOURCE_$$outputArray$1 == 18bv32 || _READ_SOURCE_$$outputArray$1 == 19bv32;
  requires !_WRITE_HAS_OCCURRED_$$sortedArray$1 ==> _WRITE_SOURCE_$$sortedArray$1 == 0bv32;
  requires !_READ_HAS_OCCURRED_$$sortedArray$1 ==> _READ_SOURCE_$$sortedArray$1 == 0bv32;
  requires _WRITE_HAS_OCCURRED_$$sortedArray$1 ==> false;
  requires _READ_HAS_OCCURRED_$$sortedArray$1 ==> _READ_SOURCE_$$sortedArray$1 == 1bv32 || _READ_SOURCE_$$sortedArray$1 == 2bv32;
  modifies _WRITE_HAS_OCCURRED_$$outputArray$1, _WRITE_OFFSET_$$outputArray$1;
  ensures !_WRITE_HAS_OCCURRED_$$outputArray$1 ==> _WRITE_SOURCE_$$outputArray$1 == 0bv32;
  ensures !_READ_HAS_OCCURRED_$$outputArray$1 ==> _READ_SOURCE_$$outputArray$1 == 0bv32;
  ensures _WRITE_HAS_OCCURRED_$$outputArray$1 ==> _WRITE_SOURCE_$$outputArray$1 == 6bv32 || _WRITE_SOURCE_$$outputArray$1 == 7bv32 || _WRITE_SOURCE_$$outputArray$1 == 8bv32 || _WRITE_SOURCE_$$outputArray$1 == 9bv32 || _WRITE_SOURCE_$$outputArray$1 == 13bv32 || _WRITE_SOURCE_$$outputArray$1 == 14bv32 || _WRITE_SOURCE_$$outputArray$1 == 15bv32 || _WRITE_SOURCE_$$outputArray$1 == 16bv32 || _WRITE_SOURCE_$$outputArray$1 == 20bv32 || _WRITE_SOURCE_$$outputArray$1 == 21bv32 || _WRITE_SOURCE_$$outputArray$1 == 22bv32 || _WRITE_SOURCE_$$outputArray$1 == 23bv32;
  ensures _READ_HAS_OCCURRED_$$outputArray$1 ==> _READ_SOURCE_$$outputArray$1 == 3bv32 || _READ_SOURCE_$$outputArray$1 == 4bv32 || _READ_SOURCE_$$outputArray$1 == 5bv32 || _READ_SOURCE_$$outputArray$1 == 10bv32 || _READ_SOURCE_$$outputArray$1 == 11bv32 || _READ_SOURCE_$$outputArray$1 == 12bv32 || _READ_SOURCE_$$outputArray$1 == 17bv32 || _READ_SOURCE_$$outputArray$1 == 18bv32 || _READ_SOURCE_$$outputArray$1 == 19bv32;
  ensures !_WRITE_HAS_OCCURRED_$$sortedArray$1 ==> _WRITE_SOURCE_$$sortedArray$1 == 0bv32;
  ensures !_READ_HAS_OCCURRED_$$sortedArray$1 ==> _READ_SOURCE_$$sortedArray$1 == 0bv32;
  ensures _WRITE_HAS_OCCURRED_$$sortedArray$1 ==> false;
  ensures _READ_HAS_OCCURRED_$$sortedArray$1 ==> _READ_SOURCE_$$sortedArray$1 == 1bv32 || _READ_SOURCE_$$sortedArray$1 == 2bv32;



implementation {:inline 1} _LOG_WRITE_$$outputArray(_P$1: bool, _offset$1: bv32, _source$1: bv32)
{
  var track: bool;


  _LOG_WRITE:
    havoc track;
    _WRITE_HAS_OCCURRED_$$outputArray$1 := (if _P$1 && track then true else _WRITE_HAS_OCCURRED_$$outputArray$1);
    _WRITE_OFFSET_$$outputArray$1 := (if _P$1 && track then _offset$1 else _WRITE_OFFSET_$$outputArray$1);
    _WRITE_SOURCE_$$outputArray$1 := (if _P$1 && track then _source$1 else _WRITE_SOURCE_$$outputArray$1);
    return;
}



procedure {:inline 1} _CHECK_WRITE_$$outputArray(_P$2: bool, _offset$2: bv32);
  requires {:race} {:write_write} !(_P$2 && _WRITE_HAS_OCCURRED_$$outputArray$1 && _WRITE_OFFSET_$$outputArray$1 == _offset$2);
  requires {:race} {:read_write} !(_P$2 && _READ_HAS_OCCURRED_$$outputArray$1 && _READ_OFFSET_$$outputArray$1 == _offset$2);
  requires !_WRITE_HAS_OCCURRED_$$outputArray$1 ==> _WRITE_SOURCE_$$outputArray$1 == 0bv32;
  requires !_READ_HAS_OCCURRED_$$outputArray$1 ==> _READ_SOURCE_$$outputArray$1 == 0bv32;
  requires _WRITE_HAS_OCCURRED_$$outputArray$1 ==> _WRITE_SOURCE_$$outputArray$1 == 6bv32 || _WRITE_SOURCE_$$outputArray$1 == 7bv32 || _WRITE_SOURCE_$$outputArray$1 == 8bv32 || _WRITE_SOURCE_$$outputArray$1 == 9bv32 || _WRITE_SOURCE_$$outputArray$1 == 13bv32 || _WRITE_SOURCE_$$outputArray$1 == 14bv32 || _WRITE_SOURCE_$$outputArray$1 == 15bv32 || _WRITE_SOURCE_$$outputArray$1 == 16bv32 || _WRITE_SOURCE_$$outputArray$1 == 20bv32 || _WRITE_SOURCE_$$outputArray$1 == 21bv32 || _WRITE_SOURCE_$$outputArray$1 == 22bv32 || _WRITE_SOURCE_$$outputArray$1 == 23bv32;
  requires _READ_HAS_OCCURRED_$$outputArray$1 ==> _READ_SOURCE_$$outputArray$1 == 3bv32 || _READ_SOURCE_$$outputArray$1 == 4bv32 || _READ_SOURCE_$$outputArray$1 == 5bv32 || _READ_SOURCE_$$outputArray$1 == 10bv32 || _READ_SOURCE_$$outputArray$1 == 11bv32 || _READ_SOURCE_$$outputArray$1 == 12bv32 || _READ_SOURCE_$$outputArray$1 == 17bv32 || _READ_SOURCE_$$outputArray$1 == 18bv32 || _READ_SOURCE_$$outputArray$1 == 19bv32;
  requires !_WRITE_HAS_OCCURRED_$$sortedArray$1 ==> _WRITE_SOURCE_$$sortedArray$1 == 0bv32;
  requires !_READ_HAS_OCCURRED_$$sortedArray$1 ==> _READ_SOURCE_$$sortedArray$1 == 0bv32;
  requires _WRITE_HAS_OCCURRED_$$sortedArray$1 ==> false;
  requires _READ_HAS_OCCURRED_$$sortedArray$1 ==> _READ_SOURCE_$$sortedArray$1 == 1bv32 || _READ_SOURCE_$$sortedArray$1 == 2bv32;
  ensures !_WRITE_HAS_OCCURRED_$$outputArray$1 ==> _WRITE_SOURCE_$$outputArray$1 == 0bv32;
  ensures !_READ_HAS_OCCURRED_$$outputArray$1 ==> _READ_SOURCE_$$outputArray$1 == 0bv32;
  ensures _WRITE_HAS_OCCURRED_$$outputArray$1 ==> _WRITE_SOURCE_$$outputArray$1 == 6bv32 || _WRITE_SOURCE_$$outputArray$1 == 7bv32 || _WRITE_SOURCE_$$outputArray$1 == 8bv32 || _WRITE_SOURCE_$$outputArray$1 == 9bv32 || _WRITE_SOURCE_$$outputArray$1 == 13bv32 || _WRITE_SOURCE_$$outputArray$1 == 14bv32 || _WRITE_SOURCE_$$outputArray$1 == 15bv32 || _WRITE_SOURCE_$$outputArray$1 == 16bv32 || _WRITE_SOURCE_$$outputArray$1 == 20bv32 || _WRITE_SOURCE_$$outputArray$1 == 21bv32 || _WRITE_SOURCE_$$outputArray$1 == 22bv32 || _WRITE_SOURCE_$$outputArray$1 == 23bv32;
  ensures _READ_HAS_OCCURRED_$$outputArray$1 ==> _READ_SOURCE_$$outputArray$1 == 3bv32 || _READ_SOURCE_$$outputArray$1 == 4bv32 || _READ_SOURCE_$$outputArray$1 == 5bv32 || _READ_SOURCE_$$outputArray$1 == 10bv32 || _READ_SOURCE_$$outputArray$1 == 11bv32 || _READ_SOURCE_$$outputArray$1 == 12bv32 || _READ_SOURCE_$$outputArray$1 == 17bv32 || _READ_SOURCE_$$outputArray$1 == 18bv32 || _READ_SOURCE_$$outputArray$1 == 19bv32;
  ensures !_WRITE_HAS_OCCURRED_$$sortedArray$1 ==> _WRITE_SOURCE_$$sortedArray$1 == 0bv32;
  ensures !_READ_HAS_OCCURRED_$$sortedArray$1 ==> _READ_SOURCE_$$sortedArray$1 == 0bv32;
  ensures _WRITE_HAS_OCCURRED_$$sortedArray$1 ==> false;
  ensures _READ_HAS_OCCURRED_$$sortedArray$1 ==> _READ_SOURCE_$$sortedArray$1 == 1bv32 || _READ_SOURCE_$$sortedArray$1 == 2bv32;



var _READ_SOURCE_$$sortedArray$1: bv32;

var _WRITE_SOURCE_$$sortedArray$1: bv32;

procedure {:inline 1} _LOG_READ_$$sortedArray(_P$1: bool, _offset$1: bv32, _source$1: bv32);
  requires !_WRITE_HAS_OCCURRED_$$outputArray$1 ==> _WRITE_SOURCE_$$outputArray$1 == 0bv32;
  requires !_READ_HAS_OCCURRED_$$outputArray$1 ==> _READ_SOURCE_$$outputArray$1 == 0bv32;
  requires _WRITE_HAS_OCCURRED_$$outputArray$1 ==> _WRITE_SOURCE_$$outputArray$1 == 6bv32 || _WRITE_SOURCE_$$outputArray$1 == 7bv32 || _WRITE_SOURCE_$$outputArray$1 == 8bv32 || _WRITE_SOURCE_$$outputArray$1 == 9bv32 || _WRITE_SOURCE_$$outputArray$1 == 13bv32 || _WRITE_SOURCE_$$outputArray$1 == 14bv32 || _WRITE_SOURCE_$$outputArray$1 == 15bv32 || _WRITE_SOURCE_$$outputArray$1 == 16bv32 || _WRITE_SOURCE_$$outputArray$1 == 20bv32 || _WRITE_SOURCE_$$outputArray$1 == 21bv32 || _WRITE_SOURCE_$$outputArray$1 == 22bv32 || _WRITE_SOURCE_$$outputArray$1 == 23bv32;
  requires _READ_HAS_OCCURRED_$$outputArray$1 ==> _READ_SOURCE_$$outputArray$1 == 3bv32 || _READ_SOURCE_$$outputArray$1 == 4bv32 || _READ_SOURCE_$$outputArray$1 == 5bv32 || _READ_SOURCE_$$outputArray$1 == 10bv32 || _READ_SOURCE_$$outputArray$1 == 11bv32 || _READ_SOURCE_$$outputArray$1 == 12bv32 || _READ_SOURCE_$$outputArray$1 == 17bv32 || _READ_SOURCE_$$outputArray$1 == 18bv32 || _READ_SOURCE_$$outputArray$1 == 19bv32;
  requires !_WRITE_HAS_OCCURRED_$$sortedArray$1 ==> _WRITE_SOURCE_$$sortedArray$1 == 0bv32;
  requires !_READ_HAS_OCCURRED_$$sortedArray$1 ==> _READ_SOURCE_$$sortedArray$1 == 0bv32;
  requires _WRITE_HAS_OCCURRED_$$sortedArray$1 ==> false;
  requires _READ_HAS_OCCURRED_$$sortedArray$1 ==> _READ_SOURCE_$$sortedArray$1 == 1bv32 || _READ_SOURCE_$$sortedArray$1 == 2bv32;
  modifies _READ_HAS_OCCURRED_$$sortedArray$1, _READ_OFFSET_$$sortedArray$1;
  ensures !_WRITE_HAS_OCCURRED_$$outputArray$1 ==> _WRITE_SOURCE_$$outputArray$1 == 0bv32;
  ensures !_READ_HAS_OCCURRED_$$outputArray$1 ==> _READ_SOURCE_$$outputArray$1 == 0bv32;
  ensures _WRITE_HAS_OCCURRED_$$outputArray$1 ==> _WRITE_SOURCE_$$outputArray$1 == 6bv32 || _WRITE_SOURCE_$$outputArray$1 == 7bv32 || _WRITE_SOURCE_$$outputArray$1 == 8bv32 || _WRITE_SOURCE_$$outputArray$1 == 9bv32 || _WRITE_SOURCE_$$outputArray$1 == 13bv32 || _WRITE_SOURCE_$$outputArray$1 == 14bv32 || _WRITE_SOURCE_$$outputArray$1 == 15bv32 || _WRITE_SOURCE_$$outputArray$1 == 16bv32 || _WRITE_SOURCE_$$outputArray$1 == 20bv32 || _WRITE_SOURCE_$$outputArray$1 == 21bv32 || _WRITE_SOURCE_$$outputArray$1 == 22bv32 || _WRITE_SOURCE_$$outputArray$1 == 23bv32;
  ensures _READ_HAS_OCCURRED_$$outputArray$1 ==> _READ_SOURCE_$$outputArray$1 == 3bv32 || _READ_SOURCE_$$outputArray$1 == 4bv32 || _READ_SOURCE_$$outputArray$1 == 5bv32 || _READ_SOURCE_$$outputArray$1 == 10bv32 || _READ_SOURCE_$$outputArray$1 == 11bv32 || _READ_SOURCE_$$outputArray$1 == 12bv32 || _READ_SOURCE_$$outputArray$1 == 17bv32 || _READ_SOURCE_$$outputArray$1 == 18bv32 || _READ_SOURCE_$$outputArray$1 == 19bv32;
  ensures !_WRITE_HAS_OCCURRED_$$sortedArray$1 ==> _WRITE_SOURCE_$$sortedArray$1 == 0bv32;
  ensures !_READ_HAS_OCCURRED_$$sortedArray$1 ==> _READ_SOURCE_$$sortedArray$1 == 0bv32;
  ensures _WRITE_HAS_OCCURRED_$$sortedArray$1 ==> false;
  ensures _READ_HAS_OCCURRED_$$sortedArray$1 ==> _READ_SOURCE_$$sortedArray$1 == 1bv32 || _READ_SOURCE_$$sortedArray$1 == 2bv32;



implementation {:inline 1} _LOG_READ_$$sortedArray(_P$1: bool, _offset$1: bv32, _source$1: bv32)
{
  var track: bool;


  _LOG_READ:
    havoc track;
    _READ_HAS_OCCURRED_$$sortedArray$1 := (if _P$1 && track then true else _READ_HAS_OCCURRED_$$sortedArray$1);
    _READ_OFFSET_$$sortedArray$1 := (if _P$1 && track then _offset$1 else _READ_OFFSET_$$sortedArray$1);
    _READ_SOURCE_$$sortedArray$1 := (if _P$1 && track then _source$1 else _READ_SOURCE_$$sortedArray$1);
    return;
}



procedure {:inline 1} _CHECK_READ_$$sortedArray(_P$2: bool, _offset$2: bv32);
  requires {:race} {:write_read} !(_P$2 && _WRITE_HAS_OCCURRED_$$sortedArray$1 && _WRITE_OFFSET_$$sortedArray$1 == _offset$2 && $$sortedArray[_WRITE_OFFSET_$$sortedArray$1] != $$sortedArray[_offset$2]);
  requires !_WRITE_HAS_OCCURRED_$$outputArray$1 ==> _WRITE_SOURCE_$$outputArray$1 == 0bv32;
  requires !_READ_HAS_OCCURRED_$$outputArray$1 ==> _READ_SOURCE_$$outputArray$1 == 0bv32;
  requires _WRITE_HAS_OCCURRED_$$outputArray$1 ==> _WRITE_SOURCE_$$outputArray$1 == 6bv32 || _WRITE_SOURCE_$$outputArray$1 == 7bv32 || _WRITE_SOURCE_$$outputArray$1 == 8bv32 || _WRITE_SOURCE_$$outputArray$1 == 9bv32 || _WRITE_SOURCE_$$outputArray$1 == 13bv32 || _WRITE_SOURCE_$$outputArray$1 == 14bv32 || _WRITE_SOURCE_$$outputArray$1 == 15bv32 || _WRITE_SOURCE_$$outputArray$1 == 16bv32 || _WRITE_SOURCE_$$outputArray$1 == 20bv32 || _WRITE_SOURCE_$$outputArray$1 == 21bv32 || _WRITE_SOURCE_$$outputArray$1 == 22bv32 || _WRITE_SOURCE_$$outputArray$1 == 23bv32;
  requires _READ_HAS_OCCURRED_$$outputArray$1 ==> _READ_SOURCE_$$outputArray$1 == 3bv32 || _READ_SOURCE_$$outputArray$1 == 4bv32 || _READ_SOURCE_$$outputArray$1 == 5bv32 || _READ_SOURCE_$$outputArray$1 == 10bv32 || _READ_SOURCE_$$outputArray$1 == 11bv32 || _READ_SOURCE_$$outputArray$1 == 12bv32 || _READ_SOURCE_$$outputArray$1 == 17bv32 || _READ_SOURCE_$$outputArray$1 == 18bv32 || _READ_SOURCE_$$outputArray$1 == 19bv32;
  requires !_WRITE_HAS_OCCURRED_$$sortedArray$1 ==> _WRITE_SOURCE_$$sortedArray$1 == 0bv32;
  requires !_READ_HAS_OCCURRED_$$sortedArray$1 ==> _READ_SOURCE_$$sortedArray$1 == 0bv32;
  requires _WRITE_HAS_OCCURRED_$$sortedArray$1 ==> false;
  requires _READ_HAS_OCCURRED_$$sortedArray$1 ==> _READ_SOURCE_$$sortedArray$1 == 1bv32 || _READ_SOURCE_$$sortedArray$1 == 2bv32;
  ensures !_WRITE_HAS_OCCURRED_$$outputArray$1 ==> _WRITE_SOURCE_$$outputArray$1 == 0bv32;
  ensures !_READ_HAS_OCCURRED_$$outputArray$1 ==> _READ_SOURCE_$$outputArray$1 == 0bv32;
  ensures _WRITE_HAS_OCCURRED_$$outputArray$1 ==> _WRITE_SOURCE_$$outputArray$1 == 6bv32 || _WRITE_SOURCE_$$outputArray$1 == 7bv32 || _WRITE_SOURCE_$$outputArray$1 == 8bv32 || _WRITE_SOURCE_$$outputArray$1 == 9bv32 || _WRITE_SOURCE_$$outputArray$1 == 13bv32 || _WRITE_SOURCE_$$outputArray$1 == 14bv32 || _WRITE_SOURCE_$$outputArray$1 == 15bv32 || _WRITE_SOURCE_$$outputArray$1 == 16bv32 || _WRITE_SOURCE_$$outputArray$1 == 20bv32 || _WRITE_SOURCE_$$outputArray$1 == 21bv32 || _WRITE_SOURCE_$$outputArray$1 == 22bv32 || _WRITE_SOURCE_$$outputArray$1 == 23bv32;
  ensures _READ_HAS_OCCURRED_$$outputArray$1 ==> _READ_SOURCE_$$outputArray$1 == 3bv32 || _READ_SOURCE_$$outputArray$1 == 4bv32 || _READ_SOURCE_$$outputArray$1 == 5bv32 || _READ_SOURCE_$$outputArray$1 == 10bv32 || _READ_SOURCE_$$outputArray$1 == 11bv32 || _READ_SOURCE_$$outputArray$1 == 12bv32 || _READ_SOURCE_$$outputArray$1 == 17bv32 || _READ_SOURCE_$$outputArray$1 == 18bv32 || _READ_SOURCE_$$outputArray$1 == 19bv32;
  ensures !_WRITE_HAS_OCCURRED_$$sortedArray$1 ==> _WRITE_SOURCE_$$sortedArray$1 == 0bv32;
  ensures !_READ_HAS_OCCURRED_$$sortedArray$1 ==> _READ_SOURCE_$$sortedArray$1 == 0bv32;
  ensures _WRITE_HAS_OCCURRED_$$sortedArray$1 ==> false;
  ensures _READ_HAS_OCCURRED_$$sortedArray$1 ==> _READ_SOURCE_$$sortedArray$1 == 1bv32 || _READ_SOURCE_$$sortedArray$1 == 2bv32;



procedure {:inline 1} _LOG_WRITE_$$sortedArray(_P$1: bool, _offset$1: bv32, _source$1: bv32);
  requires !_WRITE_HAS_OCCURRED_$$outputArray$1 ==> _WRITE_SOURCE_$$outputArray$1 == 0bv32;
  requires !_READ_HAS_OCCURRED_$$outputArray$1 ==> _READ_SOURCE_$$outputArray$1 == 0bv32;
  requires _WRITE_HAS_OCCURRED_$$outputArray$1 ==> _WRITE_SOURCE_$$outputArray$1 == 6bv32 || _WRITE_SOURCE_$$outputArray$1 == 7bv32 || _WRITE_SOURCE_$$outputArray$1 == 8bv32 || _WRITE_SOURCE_$$outputArray$1 == 9bv32 || _WRITE_SOURCE_$$outputArray$1 == 13bv32 || _WRITE_SOURCE_$$outputArray$1 == 14bv32 || _WRITE_SOURCE_$$outputArray$1 == 15bv32 || _WRITE_SOURCE_$$outputArray$1 == 16bv32 || _WRITE_SOURCE_$$outputArray$1 == 20bv32 || _WRITE_SOURCE_$$outputArray$1 == 21bv32 || _WRITE_SOURCE_$$outputArray$1 == 22bv32 || _WRITE_SOURCE_$$outputArray$1 == 23bv32;
  requires _READ_HAS_OCCURRED_$$outputArray$1 ==> _READ_SOURCE_$$outputArray$1 == 3bv32 || _READ_SOURCE_$$outputArray$1 == 4bv32 || _READ_SOURCE_$$outputArray$1 == 5bv32 || _READ_SOURCE_$$outputArray$1 == 10bv32 || _READ_SOURCE_$$outputArray$1 == 11bv32 || _READ_SOURCE_$$outputArray$1 == 12bv32 || _READ_SOURCE_$$outputArray$1 == 17bv32 || _READ_SOURCE_$$outputArray$1 == 18bv32 || _READ_SOURCE_$$outputArray$1 == 19bv32;
  requires !_WRITE_HAS_OCCURRED_$$sortedArray$1 ==> _WRITE_SOURCE_$$sortedArray$1 == 0bv32;
  requires !_READ_HAS_OCCURRED_$$sortedArray$1 ==> _READ_SOURCE_$$sortedArray$1 == 0bv32;
  requires _WRITE_HAS_OCCURRED_$$sortedArray$1 ==> false;
  requires _READ_HAS_OCCURRED_$$sortedArray$1 ==> _READ_SOURCE_$$sortedArray$1 == 1bv32 || _READ_SOURCE_$$sortedArray$1 == 2bv32;
  modifies _WRITE_HAS_OCCURRED_$$sortedArray$1, _WRITE_OFFSET_$$sortedArray$1;
  ensures !_WRITE_HAS_OCCURRED_$$outputArray$1 ==> _WRITE_SOURCE_$$outputArray$1 == 0bv32;
  ensures !_READ_HAS_OCCURRED_$$outputArray$1 ==> _READ_SOURCE_$$outputArray$1 == 0bv32;
  ensures _WRITE_HAS_OCCURRED_$$outputArray$1 ==> _WRITE_SOURCE_$$outputArray$1 == 6bv32 || _WRITE_SOURCE_$$outputArray$1 == 7bv32 || _WRITE_SOURCE_$$outputArray$1 == 8bv32 || _WRITE_SOURCE_$$outputArray$1 == 9bv32 || _WRITE_SOURCE_$$outputArray$1 == 13bv32 || _WRITE_SOURCE_$$outputArray$1 == 14bv32 || _WRITE_SOURCE_$$outputArray$1 == 15bv32 || _WRITE_SOURCE_$$outputArray$1 == 16bv32 || _WRITE_SOURCE_$$outputArray$1 == 20bv32 || _WRITE_SOURCE_$$outputArray$1 == 21bv32 || _WRITE_SOURCE_$$outputArray$1 == 22bv32 || _WRITE_SOURCE_$$outputArray$1 == 23bv32;
  ensures _READ_HAS_OCCURRED_$$outputArray$1 ==> _READ_SOURCE_$$outputArray$1 == 3bv32 || _READ_SOURCE_$$outputArray$1 == 4bv32 || _READ_SOURCE_$$outputArray$1 == 5bv32 || _READ_SOURCE_$$outputArray$1 == 10bv32 || _READ_SOURCE_$$outputArray$1 == 11bv32 || _READ_SOURCE_$$outputArray$1 == 12bv32 || _READ_SOURCE_$$outputArray$1 == 17bv32 || _READ_SOURCE_$$outputArray$1 == 18bv32 || _READ_SOURCE_$$outputArray$1 == 19bv32;
  ensures !_WRITE_HAS_OCCURRED_$$sortedArray$1 ==> _WRITE_SOURCE_$$sortedArray$1 == 0bv32;
  ensures !_READ_HAS_OCCURRED_$$sortedArray$1 ==> _READ_SOURCE_$$sortedArray$1 == 0bv32;
  ensures _WRITE_HAS_OCCURRED_$$sortedArray$1 ==> false;
  ensures _READ_HAS_OCCURRED_$$sortedArray$1 ==> _READ_SOURCE_$$sortedArray$1 == 1bv32 || _READ_SOURCE_$$sortedArray$1 == 2bv32;



implementation {:inline 1} _LOG_WRITE_$$sortedArray(_P$1: bool, _offset$1: bv32, _source$1: bv32)
{
  var track: bool;


  _LOG_WRITE:
    havoc track;
    _WRITE_HAS_OCCURRED_$$sortedArray$1 := (if _P$1 && track then true else _WRITE_HAS_OCCURRED_$$sortedArray$1);
    _WRITE_OFFSET_$$sortedArray$1 := (if _P$1 && track then _offset$1 else _WRITE_OFFSET_$$sortedArray$1);
    _WRITE_SOURCE_$$sortedArray$1 := (if _P$1 && track then _source$1 else _WRITE_SOURCE_$$sortedArray$1);
    return;
}



procedure {:inline 1} _CHECK_WRITE_$$sortedArray(_P$2: bool, _offset$2: bv32);
  requires {:race} {:write_write} !(_P$2 && _WRITE_HAS_OCCURRED_$$sortedArray$1 && _WRITE_OFFSET_$$sortedArray$1 == _offset$2 && $$sortedArray[_WRITE_OFFSET_$$sortedArray$1] != $$sortedArray[_offset$2]);
  requires {:race} {:read_write} !(_P$2 && _READ_HAS_OCCURRED_$$sortedArray$1 && _READ_OFFSET_$$sortedArray$1 == _offset$2 && $$sortedArray[_READ_OFFSET_$$sortedArray$1] != $$sortedArray[_offset$2]);
  requires !_WRITE_HAS_OCCURRED_$$outputArray$1 ==> _WRITE_SOURCE_$$outputArray$1 == 0bv32;
  requires !_READ_HAS_OCCURRED_$$outputArray$1 ==> _READ_SOURCE_$$outputArray$1 == 0bv32;
  requires _WRITE_HAS_OCCURRED_$$outputArray$1 ==> _WRITE_SOURCE_$$outputArray$1 == 6bv32 || _WRITE_SOURCE_$$outputArray$1 == 7bv32 || _WRITE_SOURCE_$$outputArray$1 == 8bv32 || _WRITE_SOURCE_$$outputArray$1 == 9bv32 || _WRITE_SOURCE_$$outputArray$1 == 13bv32 || _WRITE_SOURCE_$$outputArray$1 == 14bv32 || _WRITE_SOURCE_$$outputArray$1 == 15bv32 || _WRITE_SOURCE_$$outputArray$1 == 16bv32 || _WRITE_SOURCE_$$outputArray$1 == 20bv32 || _WRITE_SOURCE_$$outputArray$1 == 21bv32 || _WRITE_SOURCE_$$outputArray$1 == 22bv32 || _WRITE_SOURCE_$$outputArray$1 == 23bv32;
  requires _READ_HAS_OCCURRED_$$outputArray$1 ==> _READ_SOURCE_$$outputArray$1 == 3bv32 || _READ_SOURCE_$$outputArray$1 == 4bv32 || _READ_SOURCE_$$outputArray$1 == 5bv32 || _READ_SOURCE_$$outputArray$1 == 10bv32 || _READ_SOURCE_$$outputArray$1 == 11bv32 || _READ_SOURCE_$$outputArray$1 == 12bv32 || _READ_SOURCE_$$outputArray$1 == 17bv32 || _READ_SOURCE_$$outputArray$1 == 18bv32 || _READ_SOURCE_$$outputArray$1 == 19bv32;
  requires !_WRITE_HAS_OCCURRED_$$sortedArray$1 ==> _WRITE_SOURCE_$$sortedArray$1 == 0bv32;
  requires !_READ_HAS_OCCURRED_$$sortedArray$1 ==> _READ_SOURCE_$$sortedArray$1 == 0bv32;
  requires _WRITE_HAS_OCCURRED_$$sortedArray$1 ==> false;
  requires _READ_HAS_OCCURRED_$$sortedArray$1 ==> _READ_SOURCE_$$sortedArray$1 == 1bv32 || _READ_SOURCE_$$sortedArray$1 == 2bv32;
  ensures !_WRITE_HAS_OCCURRED_$$outputArray$1 ==> _WRITE_SOURCE_$$outputArray$1 == 0bv32;
  ensures !_READ_HAS_OCCURRED_$$outputArray$1 ==> _READ_SOURCE_$$outputArray$1 == 0bv32;
  ensures _WRITE_HAS_OCCURRED_$$outputArray$1 ==> _WRITE_SOURCE_$$outputArray$1 == 6bv32 || _WRITE_SOURCE_$$outputArray$1 == 7bv32 || _WRITE_SOURCE_$$outputArray$1 == 8bv32 || _WRITE_SOURCE_$$outputArray$1 == 9bv32 || _WRITE_SOURCE_$$outputArray$1 == 13bv32 || _WRITE_SOURCE_$$outputArray$1 == 14bv32 || _WRITE_SOURCE_$$outputArray$1 == 15bv32 || _WRITE_SOURCE_$$outputArray$1 == 16bv32 || _WRITE_SOURCE_$$outputArray$1 == 20bv32 || _WRITE_SOURCE_$$outputArray$1 == 21bv32 || _WRITE_SOURCE_$$outputArray$1 == 22bv32 || _WRITE_SOURCE_$$outputArray$1 == 23bv32;
  ensures _READ_HAS_OCCURRED_$$outputArray$1 ==> _READ_SOURCE_$$outputArray$1 == 3bv32 || _READ_SOURCE_$$outputArray$1 == 4bv32 || _READ_SOURCE_$$outputArray$1 == 5bv32 || _READ_SOURCE_$$outputArray$1 == 10bv32 || _READ_SOURCE_$$outputArray$1 == 11bv32 || _READ_SOURCE_$$outputArray$1 == 12bv32 || _READ_SOURCE_$$outputArray$1 == 17bv32 || _READ_SOURCE_$$outputArray$1 == 18bv32 || _READ_SOURCE_$$outputArray$1 == 19bv32;
  ensures !_WRITE_HAS_OCCURRED_$$sortedArray$1 ==> _WRITE_SOURCE_$$sortedArray$1 == 0bv32;
  ensures !_READ_HAS_OCCURRED_$$sortedArray$1 ==> _READ_SOURCE_$$sortedArray$1 == 0bv32;
  ensures _WRITE_HAS_OCCURRED_$$sortedArray$1 ==> false;
  ensures _READ_HAS_OCCURRED_$$sortedArray$1 ==> _READ_SOURCE_$$sortedArray$1 == 1bv32 || _READ_SOURCE_$$sortedArray$1 == 2bv32;



implementation {:inline 1} barrier(__local_fence: bv1, __global_fence: bv1)
{

  __BarrierImpl:
    goto anon4_Then, anon4_Else;

  anon4_Else:
    assume {:partition} true;
    goto anon0;

  anon0:
    assume group_id_x$1 == group_id_x$2 && group_id_y$1 == group_id_y$2 && group_id_z$1 == group_id_z$2 ==> __global_fence == 1bv1 ==> !_READ_HAS_OCCURRED_$$outputArray$1;
    assume group_id_x$1 == group_id_x$2 && group_id_y$1 == group_id_y$2 && group_id_z$1 == group_id_z$2 ==> __global_fence == 1bv1 ==> !_WRITE_HAS_OCCURRED_$$outputArray$1;
    goto anon1;

  anon1:
    assume group_id_x$1 == group_id_x$2 && group_id_y$1 == group_id_y$2 && group_id_z$1 == group_id_z$2 ==> __global_fence == 1bv1 ==> !_READ_HAS_OCCURRED_$$sortedArray$1;
    assume group_id_x$1 == group_id_x$2 && group_id_y$1 == group_id_y$2 && group_id_z$1 == group_id_z$2 ==> __global_fence == 1bv1 ==> !_WRITE_HAS_OCCURRED_$$sortedArray$1;
    goto anon2;

  anon2:
    goto anon5_Then, anon5_Else;

  anon5_Else:
    assume {:partition} !(group_id_x$1 == group_id_x$2 && group_id_y$1 == group_id_y$2 && group_id_z$1 == group_id_z$2 && (__global_fence == 1bv1 || __global_fence == 1bv1));
    return;

  anon5_Then:
    assume {:partition} group_id_x$1 == group_id_x$2 && group_id_y$1 == group_id_y$2 && group_id_z$1 == group_id_z$2 && (__global_fence == 1bv1 || __global_fence == 1bv1);
    havoc $$sortedArray;
    return;

  anon4_Then:
    assume {:partition} false;
    return;
}



function {:bvbuiltin "bvsgt"} BV32_SGT(bv32, bv32) : bool;

function {:bvbuiltin "bvsge"} BV32_SGE(bv32, bv32) : bool;

function {:bvbuiltin "bvslt"} BV32_SLT(bv32, bv32) : bool;
