@echo off

setlocal

set BATCH_FILE_DIR=%~dp0

rem Handle -o argument
if [%1]==[-o] set OUT=%2
if [%OUT%]==[] set OUT=%~n1.gbpl

rem If -o argument was supplied, ignore first two parameters
if %1 == -o shift & shift

set IN_PREFIX=%~n1

rem Now build string containing remaining parameters
set PARAMS=%1
:loop
shift
if [%1]==[] goto afterloop
set PARAMS=%PARAMS% %1
goto loop
:afterloop

clang -I"%BATCH_FILE_DIR%include-blang" -Xclang -cl-std=CL1.2 -O0 -ccc-host-triple nvptx--bugle -I"%BATCH_FILE_DIR%libclc/generic/include" -Xclang -mlink-bitcode-file -Xclang "%BATCH_FILE_DIR%libclc/nvptx--bugle/lib/builtins.bc" -Dcl_khr_fp64 -Dcl_clang_storage_class_specifiers -D__OPENCL_VERSION__ -g -emit-llvm -c -o %IN_PREFIX%.bc %PARAMS% || exit /b 1
opt -mem2reg -globaldce -o %IN_PREFIX%.opt.bc %IN_PREFIX%.bc || exit /b 1
bugle -l cl -o %OUT% %IN_PREFIX%.opt.bc || exit /b 1

endlocal
