@echo off

setlocal

set BATCH_FILE_DIR=%~dp0

rem Handle -o argument
if [%1]==[-o] set OUT=%2
if [%OUT%]==[] set OUT=%~n1.gbpl

rem If -o argument was supplied, ignore first two parameters
if %1 == -o shift & shift

set IN_PREFIX=%~n1

rem Now build string containing remaining parameters
set PARAMS=%1
:loop
shift
if [%1]==[] goto afterloop
set PARAMS=%PARAMS% %1
goto loop
:afterloop

clang -I"%BATCH_FILE_DIR%include-blang" -ccc-host-triple nvptx--bugle -emit-llvm -Xclang -fcuda-is-device -D__CUDA_ARCH__ -g -emit-llvm -c -o %IN_PREFIX%.bc %PARAMS% || exit /b 1
opt -mem2reg -globaldce -o %IN_PREFIX%.opt.bc %IN_PREFIX%.bc || exit /b 1
bugle -l cu -o %OUT% %IN_PREFIX%.opt.bc || exit /b 1

endlocal
