procedure _ATOMIC_OP32(x: [bv32]bv32, y: bv32) returns (z$1: bv32, A$1: [bv32]bv32, z$2: bv32, A$2: [bv32]bv32);



var {:global} $$d_Histogram: [bv32]bv32;

var {:race_checking} {:GLOBAL} _READ_HAS_OCCURRED_$$d_Histogram: bool;

var {:race_checking} {:GLOBAL} _WRITE_HAS_OCCURRED_$$d_Histogram: bool;

var {:race_checking} {:GLOBAL} _ATOMIC_HAS_OCCURRED_$$d_Histogram: bool;

var {:race_checking} {:GLOBAL} {:elem_width 32} _READ_OFFSET_$$d_Histogram: bv32;

var {:race_checking} {:GLOBAL} {:elem_width 32} _WRITE_OFFSET_$$d_Histogram: bv32;

var {:race_checking} {:GLOBAL} {:elem_width 32} _ATOMIC_OFFSET_$$d_Histogram: bv32;

var {:race_checking} {:GLOBAL} _READ_HAS_OCCURRED_$$d_PartialHistograms: bool;

var {:race_checking} {:GLOBAL} _WRITE_HAS_OCCURRED_$$d_PartialHistograms: bool;

var {:race_checking} {:GLOBAL} _ATOMIC_HAS_OCCURRED_$$d_PartialHistograms: bool;

var {:race_checking} {:GLOBAL} {:elem_width 32} _READ_OFFSET_$$d_PartialHistograms: bv32;

var {:race_checking} {:GLOBAL} {:elem_width 32} _WRITE_OFFSET_$$d_PartialHistograms: bv32;

var {:race_checking} {:GLOBAL} {:elem_width 32} _ATOMIC_OFFSET_$$d_PartialHistograms: bv32;

var {:group_shared} $$_ZZ23mergeHistogram256KernelPjS_jE4data: [bool][bv32]bv32;

var {:race_checking} {:GROUP_SHARED} _READ_HAS_OCCURRED_$$_ZZ23mergeHistogram256KernelPjS_jE4data: bool;

var {:race_checking} {:GROUP_SHARED} _WRITE_HAS_OCCURRED_$$_ZZ23mergeHistogram256KernelPjS_jE4data: bool;

var {:race_checking} {:GROUP_SHARED} _ATOMIC_HAS_OCCURRED_$$_ZZ23mergeHistogram256KernelPjS_jE4data: bool;

var {:race_checking} {:GROUP_SHARED} {:elem_width 32} _READ_OFFSET_$$_ZZ23mergeHistogram256KernelPjS_jE4data: bv32;

var {:race_checking} {:GROUP_SHARED} {:elem_width 32} _WRITE_OFFSET_$$_ZZ23mergeHistogram256KernelPjS_jE4data: bv32;

var {:race_checking} {:GROUP_SHARED} {:elem_width 32} _ATOMIC_OFFSET_$$_ZZ23mergeHistogram256KernelPjS_jE4data: bv32;

const {:group_id_x} group_id_x$1: bv32;

const {:group_id_x} group_id_x$2: bv32;

const {:group_size_x} group_size_x: bv32;

const {:group_size_y} group_size_y: bv32;

const {:group_size_z} group_size_z: bv32;

const {:local_id_x} local_id_x$1: bv32;

const {:local_id_x} local_id_x$2: bv32;

const {:num_groups_x} num_groups_x: bv32;

const {:num_groups_y} num_groups_y: bv32;

const {:num_groups_z} num_groups_z: bv32;

function {:bvbuiltin "bvadd"} BV32_ADD(bv32, bv32) : bv32;

function {:bvbuiltin "bvlshr"} BV32_LSHR(bv32, bv32) : bv32;

function {:bvbuiltin "bvmul"} BV32_MUL(bv32, bv32) : bv32;

function {:bvbuiltin "bvugt"} BV32_UGT(bv32, bv32) : bool;

function {:bvbuiltin "bvult"} BV32_ULT(bv32, bv32) : bool;

procedure {:kernel} $_Z23mergeHistogram256KernelPjS_j($histogramCount: bv32);
  requires !_READ_HAS_OCCURRED_$$d_Histogram && !_WRITE_HAS_OCCURRED_$$d_Histogram && !_ATOMIC_HAS_OCCURRED_$$d_Histogram;
  requires !_READ_HAS_OCCURRED_$$d_PartialHistograms && !_WRITE_HAS_OCCURRED_$$d_PartialHistograms && !_ATOMIC_HAS_OCCURRED_$$d_PartialHistograms;
  requires !_READ_HAS_OCCURRED_$$_ZZ23mergeHistogram256KernelPjS_jE4data && !_WRITE_HAS_OCCURRED_$$_ZZ23mergeHistogram256KernelPjS_jE4data && !_ATOMIC_HAS_OCCURRED_$$_ZZ23mergeHistogram256KernelPjS_jE4data;
  requires BV32_SGT(group_size_x, 0bv32);
  requires BV32_SGT(num_groups_x, 0bv32);
  requires BV32_SGE(group_id_x$1, 0bv32);
  requires BV32_SGE(group_id_x$2, 0bv32);
  requires BV32_SLT(group_id_x$1, num_groups_x);
  requires BV32_SLT(group_id_x$2, num_groups_x);
  requires BV32_SGE(local_id_x$1, 0bv32);
  requires BV32_SGE(local_id_x$2, 0bv32);
  requires BV32_SLT(local_id_x$1, group_size_x);
  requires BV32_SLT(local_id_x$2, group_size_x);
  requires BV32_SGT(group_size_y, 0bv32);
  requires BV32_SGT(num_groups_y, 0bv32);
  requires BV32_SGE(group_id_y$1, 0bv32);
  requires BV32_SGE(group_id_y$2, 0bv32);
  requires BV32_SLT(group_id_y$1, num_groups_y);
  requires BV32_SLT(group_id_y$2, num_groups_y);
  requires BV32_SGE(local_id_y$1, 0bv32);
  requires BV32_SGE(local_id_y$2, 0bv32);
  requires BV32_SLT(local_id_y$1, group_size_y);
  requires BV32_SLT(local_id_y$2, group_size_y);
  requires BV32_SGT(group_size_z, 0bv32);
  requires BV32_SGT(num_groups_z, 0bv32);
  requires BV32_SGE(group_id_z$1, 0bv32);
  requires BV32_SGE(group_id_z$2, 0bv32);
  requires BV32_SLT(group_id_z$1, num_groups_z);
  requires BV32_SLT(group_id_z$2, num_groups_z);
  requires BV32_SGE(local_id_z$1, 0bv32);
  requires BV32_SGE(local_id_z$2, 0bv32);
  requires BV32_SLT(local_id_z$1, group_size_z);
  requires BV32_SLT(local_id_z$2, group_size_z);
  requires group_id_x$1 == group_id_x$2 && group_id_y$1 == group_id_y$2 && group_id_z$1 == group_id_z$2 ==> local_id_x$1 != local_id_x$2 || local_id_y$1 != local_id_y$2 || local_id_z$1 != local_id_z$2;
  modifies $$_ZZ23mergeHistogram256KernelPjS_jE4data, _WRITE_HAS_OCCURRED_$$_ZZ23mergeHistogram256KernelPjS_jE4data, _WRITE_OFFSET_$$_ZZ23mergeHistogram256KernelPjS_jE4data, _WRITE_VALUE_$$_ZZ23mergeHistogram256KernelPjS_jE4data, _WRITE_READ_BENIGN_FLAG_$$_ZZ23mergeHistogram256KernelPjS_jE4data, _WRITE_READ_BENIGN_FLAG_$$_ZZ23mergeHistogram256KernelPjS_jE4data, _READ_HAS_OCCURRED_$$_ZZ23mergeHistogram256KernelPjS_jE4data, _READ_OFFSET_$$_ZZ23mergeHistogram256KernelPjS_jE4data, _READ_VALUE_$$_ZZ23mergeHistogram256KernelPjS_jE4data, _WRITE_HAS_OCCURRED_$$d_Histogram, _WRITE_OFFSET_$$d_Histogram, _WRITE_VALUE_$$d_Histogram, _WRITE_READ_BENIGN_FLAG_$$d_Histogram, _WRITE_READ_BENIGN_FLAG_$$d_Histogram, $$d_Histogram;



implementation {:kernel} $_Z23mergeHistogram256KernelPjS_j($histogramCount: bv32)
{
  var $sum.0$1: bv32;
  var $sum.0$2: bv32;
  var $i.0$1: bv32;
  var $i.0$2: bv32;
  var $stride.0: bv32;
  var v2: bool;
  var v5$1: bv32;
  var v5$2: bv32;
  var v0$1: bool;
  var v0$2: bool;
  var v7$1: bv32;
  var v7$2: bv32;
  var v1$1: bv32;
  var v1$2: bv32;
  var v4$1: bv32;
  var v4$2: bv32;
  var v3$1: bool;
  var v3$2: bool;
  var v6$1: bool;
  var v6$2: bool;
  var p0$1: bool;
  var p0$2: bool;
  var p1$1: bool;
  var p1$2: bool;
  var p2$1: bool;
  var p2$2: bool;
  var p3$1: bool;
  var p3$2: bool;
  var p4$1: bool;
  var p4$2: bool;
  var p5$1: bool;
  var p5$2: bool;
  var p6$1: bool;
  var p6$2: bool;
  var _HAVOC_bv32$1: bv32;
  var _HAVOC_bv32$2: bv32;


  $entry:
    $sum.0$1, $i.0$1 := 0bv32, local_id_x$1;
    $sum.0$2, $i.0$2 := 0bv32, local_id_x$2;
    p0$1 := false;
    p0$2 := false;
    p2$1 := false;
    p2$2 := false;
    p5$1 := false;
    p5$2 := false;
    p6$1 := false;
    p6$2 := false;
    p0$1 := true;
    p0$2 := true;
    goto $for.cond;

  $for.cond:
    assume {:captureState "loop_head_state_1"} true;
    assert {:tag "loopCounterIsStrided"} {:thread 1} p0$1 ==> _b0 ==> BV32_AND(BV32_SUB(256bv32, 1bv32), $i.0$1) == BV32_AND(BV32_SUB(256bv32, 1bv32), local_id_x$1);
    assert {:tag "loopCounterIsStrided"} {:thread 2} p0$2 ==> _b0 ==> BV32_AND(BV32_SUB(256bv32, 1bv32), $i.0$2) == BV32_AND(BV32_SUB(256bv32, 1bv32), local_id_x$2);
    v0$1 := (if p0$1 then BV32_ULT($i.0$1, $histogramCount) else v0$1);
    v0$2 := (if p0$2 then BV32_ULT($i.0$2, $histogramCount) else v0$2);
    p1$1 := false;
    p1$2 := false;
    p1$1 := (if p0$1 then v0$1 else p1$1);
    p1$2 := (if p0$2 then v0$2 else p1$2);
    p0$1 := (if p0$1 then v0$1 else p0$1);
    p0$2 := (if p0$2 then v0$2 else p0$2);
    havoc _HAVOC_bv32$1, _HAVOC_bv32$2;
    v1$1 := (if p1$1 then _HAVOC_bv32$1 else v1$1);
    v1$2 := (if p1$2 then _HAVOC_bv32$2 else v1$2);
    $sum.0$1, $i.0$1 := (if p1$1 then BV32_ADD($sum.0$1, v1$1) else $sum.0$1), (if p1$1 then BV32_ADD($i.0$1, 256bv32) else $i.0$1);
    $sum.0$2, $i.0$2 := (if p1$2 then BV32_ADD($sum.0$2, v1$2) else $sum.0$2), (if p1$2 then BV32_ADD($i.0$2, 256bv32) else $i.0$2);
    p0$1 := (if p1$1 then true else p0$1);
    p0$2 := (if p1$2 then true else p0$2);
    goto $for.cond.backedge, $for.cond.tail;

  $for.cond.tail:
    assume !p0$1 && !p0$2;
    call {:sourceloc} {:line 22} {:col 5} {:fname "/data/InvariantGenerationBenchmarks/CUDA50/3_Imaging/histogram/mergeHistogram256Kernel.cu"} {:dir "/data/InvariantGenerationBenchmarks/CUDA50/3_Imaging/histogram"} _LOG_WRITE_$$_ZZ23mergeHistogram256KernelPjS_jE4data(true, local_id_x$1, $sum.0$1, $$_ZZ23mergeHistogram256KernelPjS_jE4data[true][local_id_x$1]);
    call _UPDATE_WRITE_READ_BENIGN_FLAG_$$_ZZ23mergeHistogram256KernelPjS_jE4data(true, local_id_x$2);
    assume {:do_not_predicate} {:captureState "check_state_0"} {:sourceloc} {:line 22} {:col 5} {:fname "/data/InvariantGenerationBenchmarks/CUDA50/3_Imaging/histogram/mergeHistogram256Kernel.cu"} {:dir "/data/InvariantGenerationBenchmarks/CUDA50/3_Imaging/histogram"} true;
    call {:state_id "check_state_0"} {:sourceloc} {:line 22} {:col 5} {:fname "/data/InvariantGenerationBenchmarks/CUDA50/3_Imaging/histogram/mergeHistogram256Kernel.cu"} {:dir "/data/InvariantGenerationBenchmarks/CUDA50/3_Imaging/histogram"} _CHECK_WRITE_$$_ZZ23mergeHistogram256KernelPjS_jE4data(true, local_id_x$2, $sum.0$2);
    assume {:captureState "call_return_state_0"} {:procedureName "_CHECK_WRITE_$$_ZZ23mergeHistogram256KernelPjS_jE4data"} true;
    $$_ZZ23mergeHistogram256KernelPjS_jE4data[true][local_id_x$1] := $sum.0$1;
    $$_ZZ23mergeHistogram256KernelPjS_jE4data[group_id_x$1 == group_id_x$2 && group_id_y$1 == group_id_y$2 && group_id_z$1 == group_id_z$2][local_id_x$2] := $sum.0$2;
    $stride.0 := 128bv32;
    goto $for.cond4;

  $for.cond4:
    assume {:captureState "loop_head_state_0"} true;
    assert {:tag "accessedOffsetsSatisfyPredicates"} _b22 ==> _WRITE_HAS_OCCURRED_$$_ZZ23mergeHistogram256KernelPjS_jE4data ==> _WRITE_OFFSET_$$_ZZ23mergeHistogram256KernelPjS_jE4data == local_id_x$1;
    assert {:tag "accessedOffsetsSatisfyPredicates"} _b21 ==> _READ_HAS_OCCURRED_$$_ZZ23mergeHistogram256KernelPjS_jE4data ==> _READ_OFFSET_$$_ZZ23mergeHistogram256KernelPjS_jE4data == local_id_x$1;
    assert {:tag "nowrite"} _b20 ==> !_WRITE_HAS_OCCURRED_$$_ZZ23mergeHistogram256KernelPjS_jE4data;
    assert {:tag "noread"} _b19 ==> !_READ_HAS_OCCURRED_$$_ZZ23mergeHistogram256KernelPjS_jE4data;
    assert {:tag "pow2Zero"} _b18 ==> $stride.0 != 0bv32;
    assert {:tag "pow2Lt"} _b17 ==> BV32_SLT($stride.0, 1bv32);
    assert {:tag "pow2Lt"} _b16 ==> BV32_SLT($stride.0, 2bv32);
    assert {:tag "pow2Lt"} _b15 ==> BV32_SLT($stride.0, 4bv32);
    assert {:tag "pow2Lt"} _b14 ==> BV32_SLT($stride.0, 8bv32);
    assert {:tag "pow2Lt"} _b13 ==> BV32_SLT($stride.0, 16bv32);
    assert {:tag "pow2Lt"} _b12 ==> BV32_SLT($stride.0, 32bv32);
    assert {:tag "pow2Lt"} _b11 ==> BV32_SLT($stride.0, 64bv32);
    assert {:tag "pow2Lt"} _b10 ==> BV32_SLT($stride.0, 128bv32);
    assert {:tag "pow2Lt"} _b9 ==> BV32_SLT($stride.0, 256bv32);
    assert {:tag "pow2Lt"} _b8 ==> BV32_SLT($stride.0, 512bv32);
    assert {:tag "pow2Lt"} _b7 ==> BV32_SLT($stride.0, 1024bv32);
    assert {:tag "pow2Lt"} _b6 ==> BV32_SLT($stride.0, 2048bv32);
    assert {:tag "pow2Lt"} _b5 ==> BV32_SLT($stride.0, 4096bv32);
    assert {:tag "pow2Lt"} _b4 ==> BV32_SLT($stride.0, 8192bv32);
    assert {:tag "pow2Lt"} _b3 ==> BV32_SLT($stride.0, 16384bv32);
    assert {:tag "pow2Lt"} _b2 ==> BV32_SLT($stride.0, 32768bv32);
    assert {:tag "pow2Disj"} _b1 ==> $stride.0 == 0bv32 || $stride.0 == 1bv32 || $stride.0 == 2bv32 || $stride.0 == 4bv32 || $stride.0 == 8bv32 || $stride.0 == 16bv32 || $stride.0 == 32bv32 || $stride.0 == 64bv32 || $stride.0 == 128bv32 || $stride.0 == 256bv32 || $stride.0 == 512bv32 || $stride.0 == 1024bv32 || $stride.0 == 2048bv32 || $stride.0 == 4096bv32 || $stride.0 == 8192bv32 || $stride.0 == 16384bv32 || $stride.0 == 32768bv32;
    v2 := BV32_UGT($stride.0, 0bv32);
    p3$1 := false;
    p3$2 := false;
    p4$1 := false;
    p4$2 := false;
    goto __partitioned_block_$truebb0_0, $falsebb0;

  $falsebb0:
    assume {:partition} !v2 && !v2;
    v6$1 := local_id_x$1 == 0bv32;
    v6$2 := local_id_x$2 == 0bv32;
    p5$1 := v6$1;
    p5$2 := v6$2;
    call {:sourceloc} {:line 36} {:col 9} {:fname "/data/InvariantGenerationBenchmarks/CUDA50/3_Imaging/histogram/mergeHistogram256Kernel.cu"} {:dir "/data/InvariantGenerationBenchmarks/CUDA50/3_Imaging/histogram"} _LOG_READ_$$_ZZ23mergeHistogram256KernelPjS_jE4data(p5$1, 0bv32, $$_ZZ23mergeHistogram256KernelPjS_jE4data[true][0bv32]);
    assume {:do_not_predicate} {:captureState "check_state_1"} {:sourceloc} {:line 36} {:col 9} {:fname "/data/InvariantGenerationBenchmarks/CUDA50/3_Imaging/histogram/mergeHistogram256Kernel.cu"} {:dir "/data/InvariantGenerationBenchmarks/CUDA50/3_Imaging/histogram"} true;
    call {:state_id "check_state_1"} {:sourceloc} {:line 36} {:col 9} {:fname "/data/InvariantGenerationBenchmarks/CUDA50/3_Imaging/histogram/mergeHistogram256Kernel.cu"} {:dir "/data/InvariantGenerationBenchmarks/CUDA50/3_Imaging/histogram"} _CHECK_READ_$$_ZZ23mergeHistogram256KernelPjS_jE4data(p5$2, 0bv32, $$_ZZ23mergeHistogram256KernelPjS_jE4data[group_id_x$1 == group_id_x$2 && group_id_y$1 == group_id_y$2 && group_id_z$1 == group_id_z$2][0bv32]);
    assume {:captureState "call_return_state_0"} {:procedureName "_CHECK_READ_$$_ZZ23mergeHistogram256KernelPjS_jE4data"} true;
    v7$1 := (if p5$1 then $$_ZZ23mergeHistogram256KernelPjS_jE4data[true][0bv32] else v7$1);
    v7$2 := (if p5$2 then $$_ZZ23mergeHistogram256KernelPjS_jE4data[group_id_x$1 == group_id_x$2 && group_id_y$1 == group_id_y$2 && group_id_z$1 == group_id_z$2][0bv32] else v7$2);
    call {:sourceloc} {:line 36} {:col 9} {:fname "/data/InvariantGenerationBenchmarks/CUDA50/3_Imaging/histogram/mergeHistogram256Kernel.cu"} {:dir "/data/InvariantGenerationBenchmarks/CUDA50/3_Imaging/histogram"} _LOG_WRITE_$$d_Histogram(p5$1, group_id_x$1, v7$1, $$d_Histogram[group_id_x$1]);
    call _UPDATE_WRITE_READ_BENIGN_FLAG_$$d_Histogram(p5$2, group_id_x$2);
    assume {:do_not_predicate} {:captureState "check_state_2"} {:sourceloc} {:line 36} {:col 9} {:fname "/data/InvariantGenerationBenchmarks/CUDA50/3_Imaging/histogram/mergeHistogram256Kernel.cu"} {:dir "/data/InvariantGenerationBenchmarks/CUDA50/3_Imaging/histogram"} true;
    call {:state_id "check_state_2"} {:sourceloc} {:line 36} {:col 9} {:fname "/data/InvariantGenerationBenchmarks/CUDA50/3_Imaging/histogram/mergeHistogram256Kernel.cu"} {:dir "/data/InvariantGenerationBenchmarks/CUDA50/3_Imaging/histogram"} _CHECK_WRITE_$$d_Histogram(p5$2, group_id_x$2, v7$2);
    assume {:captureState "call_return_state_0"} {:procedureName "_CHECK_WRITE_$$d_Histogram"} true;
    $$d_Histogram[group_id_x$1] := (if p5$1 then v7$1 else $$d_Histogram[group_id_x$1]);
    $$d_Histogram[group_id_x$2] := (if p5$2 then v7$2 else $$d_Histogram[group_id_x$2]);
    return;

  __partitioned_block_$truebb0_0:
    assume {:partition} v2 && v2;
    goto __partitioned_block_$truebb0_1;

  __partitioned_block_$truebb0_1:
    call {:line 26} {:col 9} {:fname "/data/InvariantGenerationBenchmarks/CUDA50/3_Imaging/histogram/mergeHistogram256Kernel.cu"} {:dir "/data/InvariantGenerationBenchmarks/CUDA50/3_Imaging/histogram"} $bugle_barrier(1bv1, 1bv1);
    v3$1 := BV32_ULT(local_id_x$1, $stride.0);
    v3$2 := BV32_ULT(local_id_x$2, $stride.0);
    p4$1 := v3$1;
    p4$2 := v3$2;
    call {:sourceloc} {:line 30} {:col 13} {:fname "/data/InvariantGenerationBenchmarks/CUDA50/3_Imaging/histogram/mergeHistogram256Kernel.cu"} {:dir "/data/InvariantGenerationBenchmarks/CUDA50/3_Imaging/histogram"} _LOG_READ_$$_ZZ23mergeHistogram256KernelPjS_jE4data(p4$1, BV32_ADD(local_id_x$1, $stride.0), $$_ZZ23mergeHistogram256KernelPjS_jE4data[true][BV32_ADD(local_id_x$1, $stride.0)]);
    assume {:do_not_predicate} {:captureState "check_state_3"} {:sourceloc} {:line 30} {:col 13} {:fname "/data/InvariantGenerationBenchmarks/CUDA50/3_Imaging/histogram/mergeHistogram256Kernel.cu"} {:dir "/data/InvariantGenerationBenchmarks/CUDA50/3_Imaging/histogram"} true;
    call {:state_id "check_state_3"} {:sourceloc} {:line 30} {:col 13} {:fname "/data/InvariantGenerationBenchmarks/CUDA50/3_Imaging/histogram/mergeHistogram256Kernel.cu"} {:dir "/data/InvariantGenerationBenchmarks/CUDA50/3_Imaging/histogram"} _CHECK_READ_$$_ZZ23mergeHistogram256KernelPjS_jE4data(p4$2, BV32_ADD(local_id_x$2, $stride.0), $$_ZZ23mergeHistogram256KernelPjS_jE4data[group_id_x$1 == group_id_x$2 && group_id_y$1 == group_id_y$2 && group_id_z$1 == group_id_z$2][BV32_ADD(local_id_x$2, $stride.0)]);
    assume {:captureState "call_return_state_0"} {:procedureName "_CHECK_READ_$$_ZZ23mergeHistogram256KernelPjS_jE4data"} true;
    v4$1 := (if p4$1 then $$_ZZ23mergeHistogram256KernelPjS_jE4data[true][BV32_ADD(local_id_x$1, $stride.0)] else v4$1);
    v4$2 := (if p4$2 then $$_ZZ23mergeHistogram256KernelPjS_jE4data[group_id_x$1 == group_id_x$2 && group_id_y$1 == group_id_y$2 && group_id_z$1 == group_id_z$2][BV32_ADD(local_id_x$2, $stride.0)] else v4$2);
    call {:sourceloc} {:line 30} {:col 13} {:fname "/data/InvariantGenerationBenchmarks/CUDA50/3_Imaging/histogram/mergeHistogram256Kernel.cu"} {:dir "/data/InvariantGenerationBenchmarks/CUDA50/3_Imaging/histogram"} _LOG_READ_$$_ZZ23mergeHistogram256KernelPjS_jE4data(p4$1, local_id_x$1, $$_ZZ23mergeHistogram256KernelPjS_jE4data[true][local_id_x$1]);
    assume {:do_not_predicate} {:captureState "check_state_4"} {:sourceloc} {:line 30} {:col 13} {:fname "/data/InvariantGenerationBenchmarks/CUDA50/3_Imaging/histogram/mergeHistogram256Kernel.cu"} {:dir "/data/InvariantGenerationBenchmarks/CUDA50/3_Imaging/histogram"} true;
    call {:state_id "check_state_4"} {:sourceloc} {:line 30} {:col 13} {:fname "/data/InvariantGenerationBenchmarks/CUDA50/3_Imaging/histogram/mergeHistogram256Kernel.cu"} {:dir "/data/InvariantGenerationBenchmarks/CUDA50/3_Imaging/histogram"} _CHECK_READ_$$_ZZ23mergeHistogram256KernelPjS_jE4data(p4$2, local_id_x$2, $$_ZZ23mergeHistogram256KernelPjS_jE4data[group_id_x$1 == group_id_x$2 && group_id_y$1 == group_id_y$2 && group_id_z$1 == group_id_z$2][local_id_x$2]);
    assume {:captureState "call_return_state_0"} {:procedureName "_CHECK_READ_$$_ZZ23mergeHistogram256KernelPjS_jE4data"} true;
    v5$1 := (if p4$1 then $$_ZZ23mergeHistogram256KernelPjS_jE4data[true][local_id_x$1] else v5$1);
    v5$2 := (if p4$2 then $$_ZZ23mergeHistogram256KernelPjS_jE4data[group_id_x$1 == group_id_x$2 && group_id_y$1 == group_id_y$2 && group_id_z$1 == group_id_z$2][local_id_x$2] else v5$2);
    call {:sourceloc} {:line 30} {:col 13} {:fname "/data/InvariantGenerationBenchmarks/CUDA50/3_Imaging/histogram/mergeHistogram256Kernel.cu"} {:dir "/data/InvariantGenerationBenchmarks/CUDA50/3_Imaging/histogram"} _LOG_WRITE_$$_ZZ23mergeHistogram256KernelPjS_jE4data(p4$1, local_id_x$1, BV32_ADD(v5$1, v4$1), $$_ZZ23mergeHistogram256KernelPjS_jE4data[true][local_id_x$1]);
    call _UPDATE_WRITE_READ_BENIGN_FLAG_$$_ZZ23mergeHistogram256KernelPjS_jE4data(p4$2, local_id_x$2);
    assume {:do_not_predicate} {:captureState "check_state_5"} {:sourceloc} {:line 30} {:col 13} {:fname "/data/InvariantGenerationBenchmarks/CUDA50/3_Imaging/histogram/mergeHistogram256Kernel.cu"} {:dir "/data/InvariantGenerationBenchmarks/CUDA50/3_Imaging/histogram"} true;
    call {:state_id "check_state_5"} {:sourceloc} {:line 30} {:col 13} {:fname "/data/InvariantGenerationBenchmarks/CUDA50/3_Imaging/histogram/mergeHistogram256Kernel.cu"} {:dir "/data/InvariantGenerationBenchmarks/CUDA50/3_Imaging/histogram"} _CHECK_WRITE_$$_ZZ23mergeHistogram256KernelPjS_jE4data(p4$2, local_id_x$2, BV32_ADD(v5$2, v4$2));
    assume {:captureState "call_return_state_0"} {:procedureName "_CHECK_WRITE_$$_ZZ23mergeHistogram256KernelPjS_jE4data"} true;
    $$_ZZ23mergeHistogram256KernelPjS_jE4data[true][local_id_x$1] := (if p4$1 then BV32_ADD(v5$1, v4$1) else $$_ZZ23mergeHistogram256KernelPjS_jE4data[true][local_id_x$1]);
    $$_ZZ23mergeHistogram256KernelPjS_jE4data[group_id_x$1 == group_id_x$2 && group_id_y$1 == group_id_y$2 && group_id_z$1 == group_id_z$2][local_id_x$2] := (if p4$2 then BV32_ADD(v5$2, v4$2) else $$_ZZ23mergeHistogram256KernelPjS_jE4data[group_id_x$1 == group_id_x$2 && group_id_y$1 == group_id_y$2 && group_id_z$1 == group_id_z$2][local_id_x$2]);
    $stride.0 := BV32_LSHR($stride.0, 1bv32);
    goto $for.cond4;

  $for.cond.backedge:
    assume {:backedge} p0$1 || p0$2;
    goto $for.cond;
}



procedure {:inline 1} {:barrier} $bugle_barrier($0: bv1, $1: bv1);
  requires {:barrier_divergence} group_id_x$1 == group_id_x$2 && group_id_y$1 == group_id_y$2 && group_id_z$1 == group_id_z$2 ==> true == true;
  modifies $$_ZZ23mergeHistogram256KernelPjS_jE4data, $$d_Histogram;



axiom (if group_size_y == 1bv32 then 1bv1 else 0bv1) != 0bv1;

axiom (if group_size_z == 1bv32 then 1bv1 else 0bv1) != 0bv1;

axiom (if num_groups_y == 1bv32 then 1bv1 else 0bv1) != 0bv1;

axiom (if num_groups_z == 1bv32 then 1bv1 else 0bv1) != 0bv1;

axiom (if group_size_x == 256bv32 then 1bv1 else 0bv1) != 0bv1;

axiom (if num_groups_x == 256bv32 then 1bv1 else 0bv1) != 0bv1;

const {:local_id_y} local_id_y$1: bv32;

const {:local_id_y} local_id_y$2: bv32;

const {:local_id_z} local_id_z$1: bv32;

const {:local_id_z} local_id_z$2: bv32;

const {:group_id_y} group_id_y$1: bv32;

const {:group_id_y} group_id_y$2: bv32;

const {:group_id_z} group_id_z$1: bv32;

const {:group_id_z} group_id_z$2: bv32;

function {:bvbuiltin "bvsub"} BV32_SUB(bv32, bv32) : bv32;

function {:bvbuiltin "bvand"} BV32_AND(bv32, bv32) : bv32;

const {:stage_id 0} {:existential true} _b0: bool;

var _READ_VALUE_$$d_Histogram: bv32;

procedure {:inline 1} _LOG_READ_$$d_Histogram(_P: bool, _offset: bv32, _value: bv32);
  modifies _READ_HAS_OCCURRED_$$d_Histogram, _READ_OFFSET_$$d_Histogram, _READ_VALUE_$$d_Histogram;



implementation {:inline 1} _LOG_READ_$$d_Histogram(_P: bool, _offset: bv32, _value: bv32)
{
  var track: bool;


  _LOG_READ:
    havoc track;
    _READ_HAS_OCCURRED_$$d_Histogram := (if _P && track then true else _READ_HAS_OCCURRED_$$d_Histogram);
    _READ_OFFSET_$$d_Histogram := (if _P && track then _offset else _READ_OFFSET_$$d_Histogram);
    _READ_VALUE_$$d_Histogram := (if _P && track then _value else _READ_VALUE_$$d_Histogram);
    return;
}



procedure _CHECK_READ_$$d_Histogram(_P: bool, _offset: bv32, _value: bv32);
  requires {:array "$$d_Histogram"} {:race} {:write_read} !(_P && _WRITE_HAS_OCCURRED_$$d_Histogram && _WRITE_OFFSET_$$d_Histogram == _offset && _WRITE_READ_BENIGN_FLAG_$$d_Histogram);
  requires {:array "$$d_Histogram"} {:race} {:atomic_read} !(_P && _ATOMIC_HAS_OCCURRED_$$d_Histogram && _ATOMIC_OFFSET_$$d_Histogram == _offset);



var _WRITE_VALUE_$$d_Histogram: bv32;

var _WRITE_READ_BENIGN_FLAG_$$d_Histogram: bool;

procedure {:inline 1} _LOG_WRITE_$$d_Histogram(_P: bool, _offset: bv32, _value: bv32, _value_old: bv32);
  modifies _WRITE_HAS_OCCURRED_$$d_Histogram, _WRITE_OFFSET_$$d_Histogram, _WRITE_VALUE_$$d_Histogram, _WRITE_READ_BENIGN_FLAG_$$d_Histogram;



implementation {:inline 1} _LOG_WRITE_$$d_Histogram(_P: bool, _offset: bv32, _value: bv32, _value_old: bv32)
{
  var track: bool;


  _LOG_WRITE:
    havoc track;
    _WRITE_HAS_OCCURRED_$$d_Histogram := (if _P && track then true else _WRITE_HAS_OCCURRED_$$d_Histogram);
    _WRITE_OFFSET_$$d_Histogram := (if _P && track then _offset else _WRITE_OFFSET_$$d_Histogram);
    _WRITE_VALUE_$$d_Histogram := (if _P && track then _value else _WRITE_VALUE_$$d_Histogram);
    _WRITE_READ_BENIGN_FLAG_$$d_Histogram := (if _P && track then _value != _value_old else _WRITE_READ_BENIGN_FLAG_$$d_Histogram);
    return;
}



procedure _CHECK_WRITE_$$d_Histogram(_P: bool, _offset: bv32, _value: bv32);
  requires {:array "$$d_Histogram"} {:race} {:write_write} !(_P && _WRITE_HAS_OCCURRED_$$d_Histogram && _WRITE_OFFSET_$$d_Histogram == _offset && _WRITE_VALUE_$$d_Histogram != _value);
  requires {:array "$$d_Histogram"} {:race} {:read_write} !(_P && _READ_HAS_OCCURRED_$$d_Histogram && _READ_OFFSET_$$d_Histogram == _offset && _READ_VALUE_$$d_Histogram != _value);
  requires {:array "$$d_Histogram"} {:race} {:atomic_write} !(_P && _ATOMIC_HAS_OCCURRED_$$d_Histogram && _ATOMIC_OFFSET_$$d_Histogram == _offset);



procedure {:inline 1} _LOG_ATOMIC_$$d_Histogram(_P: bool, _offset: bv32);
  modifies _ATOMIC_HAS_OCCURRED_$$d_Histogram, _ATOMIC_OFFSET_$$d_Histogram;



implementation {:inline 1} _LOG_ATOMIC_$$d_Histogram(_P: bool, _offset: bv32)
{
  var track: bool;


  _LOG_ATOMIC:
    havoc track;
    _ATOMIC_HAS_OCCURRED_$$d_Histogram := (if _P && track then true else _ATOMIC_HAS_OCCURRED_$$d_Histogram);
    _ATOMIC_OFFSET_$$d_Histogram := (if _P && track then _offset else _ATOMIC_OFFSET_$$d_Histogram);
    return;
}



procedure _CHECK_ATOMIC_$$d_Histogram(_P: bool, _offset: bv32);
  requires {:array "$$d_Histogram"} {:race} {:write_atomic} !(_P && _WRITE_HAS_OCCURRED_$$d_Histogram && _WRITE_OFFSET_$$d_Histogram == _offset);
  requires {:array "$$d_Histogram"} {:race} {:read_atomic} !(_P && _READ_HAS_OCCURRED_$$d_Histogram && _READ_OFFSET_$$d_Histogram == _offset);



procedure {:inline 1} _UPDATE_WRITE_READ_BENIGN_FLAG_$$d_Histogram(_P: bool, _offset: bv32);
  modifies _WRITE_READ_BENIGN_FLAG_$$d_Histogram;



implementation {:inline 1} _UPDATE_WRITE_READ_BENIGN_FLAG_$$d_Histogram(_P: bool, _offset: bv32)
{

  _UPDATE_BENIGN_FLAG:
    _WRITE_READ_BENIGN_FLAG_$$d_Histogram := (if _P && _WRITE_HAS_OCCURRED_$$d_Histogram && _WRITE_OFFSET_$$d_Histogram == _offset then false else _WRITE_READ_BENIGN_FLAG_$$d_Histogram);
    return;
}



var _READ_VALUE_$$d_PartialHistograms: bv32;

procedure {:inline 1} _LOG_READ_$$d_PartialHistograms(_P: bool, _offset: bv32, _value: bv32);
  modifies _READ_HAS_OCCURRED_$$d_PartialHistograms, _READ_OFFSET_$$d_PartialHistograms, _READ_VALUE_$$d_PartialHistograms;



implementation {:inline 1} _LOG_READ_$$d_PartialHistograms(_P: bool, _offset: bv32, _value: bv32)
{
  var track: bool;


  _LOG_READ:
    havoc track;
    _READ_HAS_OCCURRED_$$d_PartialHistograms := (if _P && track then true else _READ_HAS_OCCURRED_$$d_PartialHistograms);
    _READ_OFFSET_$$d_PartialHistograms := (if _P && track then _offset else _READ_OFFSET_$$d_PartialHistograms);
    _READ_VALUE_$$d_PartialHistograms := (if _P && track then _value else _READ_VALUE_$$d_PartialHistograms);
    return;
}



procedure _CHECK_READ_$$d_PartialHistograms(_P: bool, _offset: bv32, _value: bv32);
  requires {:array "$$d_PartialHistograms"} {:race} {:write_read} !(_P && _WRITE_HAS_OCCURRED_$$d_PartialHistograms && _WRITE_OFFSET_$$d_PartialHistograms == _offset && _WRITE_READ_BENIGN_FLAG_$$d_PartialHistograms);
  requires {:array "$$d_PartialHistograms"} {:race} {:atomic_read} !(_P && _ATOMIC_HAS_OCCURRED_$$d_PartialHistograms && _ATOMIC_OFFSET_$$d_PartialHistograms == _offset);



var _WRITE_VALUE_$$d_PartialHistograms: bv32;

var _WRITE_READ_BENIGN_FLAG_$$d_PartialHistograms: bool;

procedure {:inline 1} _LOG_WRITE_$$d_PartialHistograms(_P: bool, _offset: bv32, _value: bv32, _value_old: bv32);
  modifies _WRITE_HAS_OCCURRED_$$d_PartialHistograms, _WRITE_OFFSET_$$d_PartialHistograms, _WRITE_VALUE_$$d_PartialHistograms, _WRITE_READ_BENIGN_FLAG_$$d_PartialHistograms;



implementation {:inline 1} _LOG_WRITE_$$d_PartialHistograms(_P: bool, _offset: bv32, _value: bv32, _value_old: bv32)
{
  var track: bool;


  _LOG_WRITE:
    havoc track;
    _WRITE_HAS_OCCURRED_$$d_PartialHistograms := (if _P && track then true else _WRITE_HAS_OCCURRED_$$d_PartialHistograms);
    _WRITE_OFFSET_$$d_PartialHistograms := (if _P && track then _offset else _WRITE_OFFSET_$$d_PartialHistograms);
    _WRITE_VALUE_$$d_PartialHistograms := (if _P && track then _value else _WRITE_VALUE_$$d_PartialHistograms);
    _WRITE_READ_BENIGN_FLAG_$$d_PartialHistograms := (if _P && track then _value != _value_old else _WRITE_READ_BENIGN_FLAG_$$d_PartialHistograms);
    return;
}



procedure _CHECK_WRITE_$$d_PartialHistograms(_P: bool, _offset: bv32, _value: bv32);
  requires {:array "$$d_PartialHistograms"} {:race} {:write_write} !(_P && _WRITE_HAS_OCCURRED_$$d_PartialHistograms && _WRITE_OFFSET_$$d_PartialHistograms == _offset && _WRITE_VALUE_$$d_PartialHistograms != _value);
  requires {:array "$$d_PartialHistograms"} {:race} {:read_write} !(_P && _READ_HAS_OCCURRED_$$d_PartialHistograms && _READ_OFFSET_$$d_PartialHistograms == _offset && _READ_VALUE_$$d_PartialHistograms != _value);
  requires {:array "$$d_PartialHistograms"} {:race} {:atomic_write} !(_P && _ATOMIC_HAS_OCCURRED_$$d_PartialHistograms && _ATOMIC_OFFSET_$$d_PartialHistograms == _offset);



procedure {:inline 1} _LOG_ATOMIC_$$d_PartialHistograms(_P: bool, _offset: bv32);
  modifies _ATOMIC_HAS_OCCURRED_$$d_PartialHistograms, _ATOMIC_OFFSET_$$d_PartialHistograms;



implementation {:inline 1} _LOG_ATOMIC_$$d_PartialHistograms(_P: bool, _offset: bv32)
{
  var track: bool;


  _LOG_ATOMIC:
    havoc track;
    _ATOMIC_HAS_OCCURRED_$$d_PartialHistograms := (if _P && track then true else _ATOMIC_HAS_OCCURRED_$$d_PartialHistograms);
    _ATOMIC_OFFSET_$$d_PartialHistograms := (if _P && track then _offset else _ATOMIC_OFFSET_$$d_PartialHistograms);
    return;
}



procedure _CHECK_ATOMIC_$$d_PartialHistograms(_P: bool, _offset: bv32);
  requires {:array "$$d_PartialHistograms"} {:race} {:write_atomic} !(_P && _WRITE_HAS_OCCURRED_$$d_PartialHistograms && _WRITE_OFFSET_$$d_PartialHistograms == _offset);
  requires {:array "$$d_PartialHistograms"} {:race} {:read_atomic} !(_P && _READ_HAS_OCCURRED_$$d_PartialHistograms && _READ_OFFSET_$$d_PartialHistograms == _offset);



procedure {:inline 1} _UPDATE_WRITE_READ_BENIGN_FLAG_$$d_PartialHistograms(_P: bool, _offset: bv32);
  modifies _WRITE_READ_BENIGN_FLAG_$$d_PartialHistograms;



implementation {:inline 1} _UPDATE_WRITE_READ_BENIGN_FLAG_$$d_PartialHistograms(_P: bool, _offset: bv32)
{

  _UPDATE_BENIGN_FLAG:
    _WRITE_READ_BENIGN_FLAG_$$d_PartialHistograms := (if _P && _WRITE_HAS_OCCURRED_$$d_PartialHistograms && _WRITE_OFFSET_$$d_PartialHistograms == _offset then false else _WRITE_READ_BENIGN_FLAG_$$d_PartialHistograms);
    return;
}



var _READ_VALUE_$$_ZZ23mergeHistogram256KernelPjS_jE4data: bv32;

procedure {:inline 1} _LOG_READ_$$_ZZ23mergeHistogram256KernelPjS_jE4data(_P: bool, _offset: bv32, _value: bv32);
  modifies _READ_HAS_OCCURRED_$$_ZZ23mergeHistogram256KernelPjS_jE4data, _READ_OFFSET_$$_ZZ23mergeHistogram256KernelPjS_jE4data, _READ_VALUE_$$_ZZ23mergeHistogram256KernelPjS_jE4data;



implementation {:inline 1} _LOG_READ_$$_ZZ23mergeHistogram256KernelPjS_jE4data(_P: bool, _offset: bv32, _value: bv32)
{
  var track: bool;


  _LOG_READ:
    havoc track;
    _READ_HAS_OCCURRED_$$_ZZ23mergeHistogram256KernelPjS_jE4data := (if _P && track then true else _READ_HAS_OCCURRED_$$_ZZ23mergeHistogram256KernelPjS_jE4data);
    _READ_OFFSET_$$_ZZ23mergeHistogram256KernelPjS_jE4data := (if _P && track then _offset else _READ_OFFSET_$$_ZZ23mergeHistogram256KernelPjS_jE4data);
    _READ_VALUE_$$_ZZ23mergeHistogram256KernelPjS_jE4data := (if _P && track then _value else _READ_VALUE_$$_ZZ23mergeHistogram256KernelPjS_jE4data);
    return;
}



procedure _CHECK_READ_$$_ZZ23mergeHistogram256KernelPjS_jE4data(_P: bool, _offset: bv32, _value: bv32);
  requires {:array "$$_ZZ23mergeHistogram256KernelPjS_jE4data"} {:race} {:write_read} !(_P && _WRITE_HAS_OCCURRED_$$_ZZ23mergeHistogram256KernelPjS_jE4data && _WRITE_OFFSET_$$_ZZ23mergeHistogram256KernelPjS_jE4data == _offset && _WRITE_READ_BENIGN_FLAG_$$_ZZ23mergeHistogram256KernelPjS_jE4data && group_id_x$1 == group_id_x$2 && group_id_y$1 == group_id_y$2 && group_id_z$1 == group_id_z$2);
  requires {:array "$$_ZZ23mergeHistogram256KernelPjS_jE4data"} {:race} {:atomic_read} !(_P && _ATOMIC_HAS_OCCURRED_$$_ZZ23mergeHistogram256KernelPjS_jE4data && _ATOMIC_OFFSET_$$_ZZ23mergeHistogram256KernelPjS_jE4data == _offset && group_id_x$1 == group_id_x$2 && group_id_y$1 == group_id_y$2 && group_id_z$1 == group_id_z$2);



var _WRITE_VALUE_$$_ZZ23mergeHistogram256KernelPjS_jE4data: bv32;

var _WRITE_READ_BENIGN_FLAG_$$_ZZ23mergeHistogram256KernelPjS_jE4data: bool;

procedure {:inline 1} _LOG_WRITE_$$_ZZ23mergeHistogram256KernelPjS_jE4data(_P: bool, _offset: bv32, _value: bv32, _value_old: bv32);
  modifies _WRITE_HAS_OCCURRED_$$_ZZ23mergeHistogram256KernelPjS_jE4data, _WRITE_OFFSET_$$_ZZ23mergeHistogram256KernelPjS_jE4data, _WRITE_VALUE_$$_ZZ23mergeHistogram256KernelPjS_jE4data, _WRITE_READ_BENIGN_FLAG_$$_ZZ23mergeHistogram256KernelPjS_jE4data;



implementation {:inline 1} _LOG_WRITE_$$_ZZ23mergeHistogram256KernelPjS_jE4data(_P: bool, _offset: bv32, _value: bv32, _value_old: bv32)
{
  var track: bool;


  _LOG_WRITE:
    havoc track;
    _WRITE_HAS_OCCURRED_$$_ZZ23mergeHistogram256KernelPjS_jE4data := (if _P && track then true else _WRITE_HAS_OCCURRED_$$_ZZ23mergeHistogram256KernelPjS_jE4data);
    _WRITE_OFFSET_$$_ZZ23mergeHistogram256KernelPjS_jE4data := (if _P && track then _offset else _WRITE_OFFSET_$$_ZZ23mergeHistogram256KernelPjS_jE4data);
    _WRITE_VALUE_$$_ZZ23mergeHistogram256KernelPjS_jE4data := (if _P && track then _value else _WRITE_VALUE_$$_ZZ23mergeHistogram256KernelPjS_jE4data);
    _WRITE_READ_BENIGN_FLAG_$$_ZZ23mergeHistogram256KernelPjS_jE4data := (if _P && track then _value != _value_old else _WRITE_READ_BENIGN_FLAG_$$_ZZ23mergeHistogram256KernelPjS_jE4data);
    return;
}



procedure _CHECK_WRITE_$$_ZZ23mergeHistogram256KernelPjS_jE4data(_P: bool, _offset: bv32, _value: bv32);
  requires {:array "$$_ZZ23mergeHistogram256KernelPjS_jE4data"} {:race} {:write_write} !(_P && _WRITE_HAS_OCCURRED_$$_ZZ23mergeHistogram256KernelPjS_jE4data && _WRITE_OFFSET_$$_ZZ23mergeHistogram256KernelPjS_jE4data == _offset && _WRITE_VALUE_$$_ZZ23mergeHistogram256KernelPjS_jE4data != _value && group_id_x$1 == group_id_x$2 && group_id_y$1 == group_id_y$2 && group_id_z$1 == group_id_z$2);
  requires {:array "$$_ZZ23mergeHistogram256KernelPjS_jE4data"} {:race} {:read_write} !(_P && _READ_HAS_OCCURRED_$$_ZZ23mergeHistogram256KernelPjS_jE4data && _READ_OFFSET_$$_ZZ23mergeHistogram256KernelPjS_jE4data == _offset && _READ_VALUE_$$_ZZ23mergeHistogram256KernelPjS_jE4data != _value && group_id_x$1 == group_id_x$2 && group_id_y$1 == group_id_y$2 && group_id_z$1 == group_id_z$2);
  requires {:array "$$_ZZ23mergeHistogram256KernelPjS_jE4data"} {:race} {:atomic_write} !(_P && _ATOMIC_HAS_OCCURRED_$$_ZZ23mergeHistogram256KernelPjS_jE4data && _ATOMIC_OFFSET_$$_ZZ23mergeHistogram256KernelPjS_jE4data == _offset && group_id_x$1 == group_id_x$2 && group_id_y$1 == group_id_y$2 && group_id_z$1 == group_id_z$2);



procedure {:inline 1} _LOG_ATOMIC_$$_ZZ23mergeHistogram256KernelPjS_jE4data(_P: bool, _offset: bv32);
  modifies _ATOMIC_HAS_OCCURRED_$$_ZZ23mergeHistogram256KernelPjS_jE4data, _ATOMIC_OFFSET_$$_ZZ23mergeHistogram256KernelPjS_jE4data;



implementation {:inline 1} _LOG_ATOMIC_$$_ZZ23mergeHistogram256KernelPjS_jE4data(_P: bool, _offset: bv32)
{
  var track: bool;


  _LOG_ATOMIC:
    havoc track;
    _ATOMIC_HAS_OCCURRED_$$_ZZ23mergeHistogram256KernelPjS_jE4data := (if _P && track then true else _ATOMIC_HAS_OCCURRED_$$_ZZ23mergeHistogram256KernelPjS_jE4data);
    _ATOMIC_OFFSET_$$_ZZ23mergeHistogram256KernelPjS_jE4data := (if _P && track then _offset else _ATOMIC_OFFSET_$$_ZZ23mergeHistogram256KernelPjS_jE4data);
    return;
}



procedure _CHECK_ATOMIC_$$_ZZ23mergeHistogram256KernelPjS_jE4data(_P: bool, _offset: bv32);
  requires {:array "$$_ZZ23mergeHistogram256KernelPjS_jE4data"} {:race} {:write_atomic} !(_P && _WRITE_HAS_OCCURRED_$$_ZZ23mergeHistogram256KernelPjS_jE4data && _WRITE_OFFSET_$$_ZZ23mergeHistogram256KernelPjS_jE4data == _offset && group_id_x$1 == group_id_x$2 && group_id_y$1 == group_id_y$2 && group_id_z$1 == group_id_z$2);
  requires {:array "$$_ZZ23mergeHistogram256KernelPjS_jE4data"} {:race} {:read_atomic} !(_P && _READ_HAS_OCCURRED_$$_ZZ23mergeHistogram256KernelPjS_jE4data && _READ_OFFSET_$$_ZZ23mergeHistogram256KernelPjS_jE4data == _offset && group_id_x$1 == group_id_x$2 && group_id_y$1 == group_id_y$2 && group_id_z$1 == group_id_z$2);



procedure {:inline 1} _UPDATE_WRITE_READ_BENIGN_FLAG_$$_ZZ23mergeHistogram256KernelPjS_jE4data(_P: bool, _offset: bv32);
  modifies _WRITE_READ_BENIGN_FLAG_$$_ZZ23mergeHistogram256KernelPjS_jE4data;



implementation {:inline 1} _UPDATE_WRITE_READ_BENIGN_FLAG_$$_ZZ23mergeHistogram256KernelPjS_jE4data(_P: bool, _offset: bv32)
{

  _UPDATE_BENIGN_FLAG:
    _WRITE_READ_BENIGN_FLAG_$$_ZZ23mergeHistogram256KernelPjS_jE4data := (if _P && _WRITE_HAS_OCCURRED_$$_ZZ23mergeHistogram256KernelPjS_jE4data && _WRITE_OFFSET_$$_ZZ23mergeHistogram256KernelPjS_jE4data == _offset then false else _WRITE_READ_BENIGN_FLAG_$$_ZZ23mergeHistogram256KernelPjS_jE4data);
    return;
}



implementation {:inline 1} $bugle_barrier($0: bv1, $1: bv1)
{

  __BarrierImpl:
    goto anon7_Then, anon7_Else;

  anon7_Else:
    assume {:partition} true;
    goto anon0;

  anon0:
    assume $0 != 0bv1 ==> !_READ_HAS_OCCURRED_$$_ZZ23mergeHistogram256KernelPjS_jE4data;
    assume $0 != 0bv1 ==> !_WRITE_HAS_OCCURRED_$$_ZZ23mergeHistogram256KernelPjS_jE4data;
    assume $0 != 0bv1 ==> !_ATOMIC_HAS_OCCURRED_$$_ZZ23mergeHistogram256KernelPjS_jE4data;
    goto anon1;

  anon1:
    goto anon8_Then, anon8_Else;

  anon8_Else:
    assume {:partition} !($0 != 0bv1 || $0 != 0bv1);
    goto anon3;

  anon3:
    assume group_id_x$1 == group_id_x$2 && group_id_y$1 == group_id_y$2 && group_id_z$1 == group_id_z$2 ==> $1 != 0bv1 ==> !_READ_HAS_OCCURRED_$$d_Histogram;
    assume group_id_x$1 == group_id_x$2 && group_id_y$1 == group_id_y$2 && group_id_z$1 == group_id_z$2 ==> $1 != 0bv1 ==> !_WRITE_HAS_OCCURRED_$$d_Histogram;
    assume group_id_x$1 == group_id_x$2 && group_id_y$1 == group_id_y$2 && group_id_z$1 == group_id_z$2 ==> $1 != 0bv1 ==> !_ATOMIC_HAS_OCCURRED_$$d_Histogram;
    goto anon4;

  anon4:
    assume group_id_x$1 == group_id_x$2 && group_id_y$1 == group_id_y$2 && group_id_z$1 == group_id_z$2 ==> $1 != 0bv1 ==> !_READ_HAS_OCCURRED_$$d_PartialHistograms;
    assume group_id_x$1 == group_id_x$2 && group_id_y$1 == group_id_y$2 && group_id_z$1 == group_id_z$2 ==> $1 != 0bv1 ==> !_WRITE_HAS_OCCURRED_$$d_PartialHistograms;
    assume group_id_x$1 == group_id_x$2 && group_id_y$1 == group_id_y$2 && group_id_z$1 == group_id_z$2 ==> $1 != 0bv1 ==> !_ATOMIC_HAS_OCCURRED_$$d_PartialHistograms;
    goto anon5;

  anon5:
    goto anon9_Then, anon9_Else;

  anon9_Else:
    assume {:partition} !(group_id_x$1 == group_id_x$2 && group_id_y$1 == group_id_y$2 && group_id_z$1 == group_id_z$2 && ($1 != 0bv1 || $1 != 0bv1));
    return;

  anon9_Then:
    assume {:partition} group_id_x$1 == group_id_x$2 && group_id_y$1 == group_id_y$2 && group_id_z$1 == group_id_z$2 && ($1 != 0bv1 || $1 != 0bv1);
    havoc $$d_Histogram;
    return;

  anon8_Then:
    assume {:partition} $0 != 0bv1 || $0 != 0bv1;
    havoc $$_ZZ23mergeHistogram256KernelPjS_jE4data;
    goto anon3;

  anon7_Then:
    assume {:partition} false;
    return;
}



function {:bvbuiltin "bvsgt"} BV32_SGT(bv32, bv32) : bool;

function {:bvbuiltin "bvsge"} BV32_SGE(bv32, bv32) : bool;

function {:bvbuiltin "bvslt"} BV32_SLT(bv32, bv32) : bool;

const {:stage_id 0} {:existential true} _b1: bool;

const {:stage_id 0} {:existential true} _b2: bool;

const {:stage_id 0} {:existential true} _b3: bool;

const {:stage_id 0} {:existential true} _b4: bool;

const {:stage_id 0} {:existential true} _b5: bool;

const {:stage_id 0} {:existential true} _b6: bool;

const {:stage_id 0} {:existential true} _b7: bool;

const {:stage_id 0} {:existential true} _b8: bool;

const {:stage_id 0} {:existential true} _b9: bool;

const {:stage_id 0} {:existential true} _b10: bool;

const {:stage_id 0} {:existential true} _b11: bool;

const {:stage_id 0} {:existential true} _b12: bool;

const {:stage_id 0} {:existential true} _b13: bool;

const {:stage_id 0} {:existential true} _b14: bool;

const {:stage_id 0} {:existential true} _b15: bool;

const {:stage_id 0} {:existential true} _b16: bool;

const {:stage_id 0} {:existential true} _b17: bool;

const {:stage_id 0} {:existential true} _b18: bool;

const {:stage_id 0} {:existential true} _b19: bool;

const {:stage_id 0} {:existential true} _b20: bool;

const {:stage_id 0} {:existential true} _b21: bool;

const {:stage_id 0} {:existential true} _b22: bool;
