procedure _ATOMIC_OP32(x: [bv32]bv32, y: bv32) returns (z$1: bv32, z$2: bv32);
  requires !_WRITE_HAS_OCCURRED_$$_ZZ3fooPiE1x$1 ==> _WRITE_SOURCE_$$_ZZ3fooPiE1x$1 == 0bv32;
  requires !_READ_HAS_OCCURRED_$$_ZZ3fooPiE1x$1 ==> _READ_SOURCE_$$_ZZ3fooPiE1x$1 == 0bv32;
  requires !_ATOMIC_HAS_OCCURRED_$$_ZZ3fooPiE1x$1 ==> _ATOMIC_SOURCE_$$_ZZ3fooPiE1x$1 == 0bv32;
  requires _WRITE_HAS_OCCURRED_$$_ZZ3fooPiE1x$1 ==> _WRITE_SOURCE_$$_ZZ3fooPiE1x$1 == 1bv32 || _WRITE_SOURCE_$$_ZZ3fooPiE1x$1 == 2bv32 || _WRITE_SOURCE_$$_ZZ3fooPiE1x$1 == 3bv32 || _WRITE_SOURCE_$$_ZZ3fooPiE1x$1 == 4bv32;
  requires _READ_HAS_OCCURRED_$$_ZZ3fooPiE1x$1 ==> false;
  requires _ATOMIC_HAS_OCCURRED_$$_ZZ3fooPiE1x$1 ==> false;
  ensures !_WRITE_HAS_OCCURRED_$$_ZZ3fooPiE1x$1 ==> _WRITE_SOURCE_$$_ZZ3fooPiE1x$1 == 0bv32;
  ensures !_READ_HAS_OCCURRED_$$_ZZ3fooPiE1x$1 ==> _READ_SOURCE_$$_ZZ3fooPiE1x$1 == 0bv32;
  ensures !_ATOMIC_HAS_OCCURRED_$$_ZZ3fooPiE1x$1 ==> _ATOMIC_SOURCE_$$_ZZ3fooPiE1x$1 == 0bv32;
  ensures _WRITE_HAS_OCCURRED_$$_ZZ3fooPiE1x$1 ==> _WRITE_SOURCE_$$_ZZ3fooPiE1x$1 == 1bv32 || _WRITE_SOURCE_$$_ZZ3fooPiE1x$1 == 2bv32 || _WRITE_SOURCE_$$_ZZ3fooPiE1x$1 == 3bv32 || _WRITE_SOURCE_$$_ZZ3fooPiE1x$1 == 4bv32;
  ensures _READ_HAS_OCCURRED_$$_ZZ3fooPiE1x$1 ==> false;
  ensures _ATOMIC_HAS_OCCURRED_$$_ZZ3fooPiE1x$1 ==> false;



procedure _ATOMIC_OP8(x: [bv32]bv8, y: bv32) returns (z$1: bv8, z$2: bv8);
  requires !_WRITE_HAS_OCCURRED_$$_ZZ3fooPiE1x$1 ==> _WRITE_SOURCE_$$_ZZ3fooPiE1x$1 == 0bv32;
  requires !_READ_HAS_OCCURRED_$$_ZZ3fooPiE1x$1 ==> _READ_SOURCE_$$_ZZ3fooPiE1x$1 == 0bv32;
  requires !_ATOMIC_HAS_OCCURRED_$$_ZZ3fooPiE1x$1 ==> _ATOMIC_SOURCE_$$_ZZ3fooPiE1x$1 == 0bv32;
  requires _WRITE_HAS_OCCURRED_$$_ZZ3fooPiE1x$1 ==> _WRITE_SOURCE_$$_ZZ3fooPiE1x$1 == 1bv32 || _WRITE_SOURCE_$$_ZZ3fooPiE1x$1 == 2bv32 || _WRITE_SOURCE_$$_ZZ3fooPiE1x$1 == 3bv32 || _WRITE_SOURCE_$$_ZZ3fooPiE1x$1 == 4bv32;
  requires _READ_HAS_OCCURRED_$$_ZZ3fooPiE1x$1 ==> false;
  requires _ATOMIC_HAS_OCCURRED_$$_ZZ3fooPiE1x$1 ==> false;
  ensures !_WRITE_HAS_OCCURRED_$$_ZZ3fooPiE1x$1 ==> _WRITE_SOURCE_$$_ZZ3fooPiE1x$1 == 0bv32;
  ensures !_READ_HAS_OCCURRED_$$_ZZ3fooPiE1x$1 ==> _READ_SOURCE_$$_ZZ3fooPiE1x$1 == 0bv32;
  ensures !_ATOMIC_HAS_OCCURRED_$$_ZZ3fooPiE1x$1 ==> _ATOMIC_SOURCE_$$_ZZ3fooPiE1x$1 == 0bv32;
  ensures _WRITE_HAS_OCCURRED_$$_ZZ3fooPiE1x$1 ==> _WRITE_SOURCE_$$_ZZ3fooPiE1x$1 == 1bv32 || _WRITE_SOURCE_$$_ZZ3fooPiE1x$1 == 2bv32 || _WRITE_SOURCE_$$_ZZ3fooPiE1x$1 == 3bv32 || _WRITE_SOURCE_$$_ZZ3fooPiE1x$1 == 4bv32;
  ensures _READ_HAS_OCCURRED_$$_ZZ3fooPiE1x$1 ==> false;
  ensures _ATOMIC_HAS_OCCURRED_$$_ZZ3fooPiE1x$1 ==> false;



var {:race_checking} {:GLOBAL} _READ_HAS_OCCURRED_$$p$1: bool;

var {:race_checking} {:GLOBAL} _WRITE_HAS_OCCURRED_$$p$1: bool;

var {:race_checking} {:GLOBAL} _ATOMIC_HAS_OCCURRED_$$p$1: bool;

var {:race_checking} {:GLOBAL} {:elem_width 32} _READ_OFFSET_$$p$1: bv32;

var {:race_checking} {:GLOBAL} {:elem_width 32} _WRITE_OFFSET_$$p$1: bv32;

var {:race_checking} {:GLOBAL} {:elem_width 32} _ATOMIC_OFFSET_$$p$1: bv32;

var {:race_checking} {:GROUP_SHARED} _READ_HAS_OCCURRED_$$_ZZ3fooPiE1x$1: bool;

var {:race_checking} {:GROUP_SHARED} _WRITE_HAS_OCCURRED_$$_ZZ3fooPiE1x$1: bool;

var {:race_checking} {:GROUP_SHARED} _ATOMIC_HAS_OCCURRED_$$_ZZ3fooPiE1x$1: bool;

var {:race_checking} {:GROUP_SHARED} {:elem_width 8} _READ_OFFSET_$$_ZZ3fooPiE1x$1: bv32;

var {:race_checking} {:GROUP_SHARED} {:elem_width 8} _WRITE_OFFSET_$$_ZZ3fooPiE1x$1: bv32;

var {:race_checking} {:GROUP_SHARED} {:elem_width 8} _ATOMIC_OFFSET_$$_ZZ3fooPiE1x$1: bv32;

const {:group_size_x} group_size_x: bv32;

const {:group_size_y} group_size_y: bv32;

const {:group_size_z} group_size_z: bv32;

const {:num_groups_x} num_groups_x: bv32;

const {:num_groups_y} num_groups_y: bv32;

const {:num_groups_z} num_groups_z: bv32;

function {:bvbuiltin "bvadd"} BV32_ADD(bv32, bv32) : bv32;

function {:bvbuiltin "bvmul"} BV32_MUL(bv32, bv32) : bv32;

function {:bvbuiltin "bvult"} BV32_ULT(bv32, bv32) : bool;

procedure {:kernel} $_Z3fooPi();
  requires !_READ_HAS_OCCURRED_$$p$1 && !_WRITE_HAS_OCCURRED_$$p$1 && !_ATOMIC_HAS_OCCURRED_$$p$1;
  requires _READ_SOURCE_$$p$1 == 0bv32;
  requires _WRITE_SOURCE_$$p$1 == 0bv32;
  requires _ATOMIC_SOURCE_$$p$1 == 0bv32;
  requires !_READ_HAS_OCCURRED_$$_ZZ3fooPiE1x$1 && !_WRITE_HAS_OCCURRED_$$_ZZ3fooPiE1x$1 && !_ATOMIC_HAS_OCCURRED_$$_ZZ3fooPiE1x$1;
  requires _READ_SOURCE_$$_ZZ3fooPiE1x$1 == 0bv32;
  requires _WRITE_SOURCE_$$_ZZ3fooPiE1x$1 == 0bv32;
  requires _ATOMIC_SOURCE_$$_ZZ3fooPiE1x$1 == 0bv32;
  requires BV32_SGT(group_size_x, 0bv32);
  requires BV32_SGT(num_groups_x, 0bv32);
  requires BV32_SGE(group_id_x$1, 0bv32);
  requires BV32_SGE(group_id_x$2, 0bv32);
  requires BV32_SLT(group_id_x$1, num_groups_x);
  requires BV32_SLT(group_id_x$2, num_groups_x);
  requires BV32_SGE(local_id_x$1, 0bv32);
  requires BV32_SGE(local_id_x$2, 0bv32);
  requires BV32_SLT(local_id_x$1, group_size_x);
  requires BV32_SLT(local_id_x$2, group_size_x);
  requires BV32_SGT(group_size_y, 0bv32);
  requires BV32_SGT(num_groups_y, 0bv32);
  requires BV32_SGE(group_id_y$1, 0bv32);
  requires BV32_SGE(group_id_y$2, 0bv32);
  requires BV32_SLT(group_id_y$1, num_groups_y);
  requires BV32_SLT(group_id_y$2, num_groups_y);
  requires BV32_SGE(local_id_y$1, 0bv32);
  requires BV32_SGE(local_id_y$2, 0bv32);
  requires BV32_SLT(local_id_y$1, group_size_y);
  requires BV32_SLT(local_id_y$2, group_size_y);
  requires BV32_SGT(group_size_z, 0bv32);
  requires BV32_SGT(num_groups_z, 0bv32);
  requires BV32_SGE(group_id_z$1, 0bv32);
  requires BV32_SGE(group_id_z$2, 0bv32);
  requires BV32_SLT(group_id_z$1, num_groups_z);
  requires BV32_SLT(group_id_z$2, num_groups_z);
  requires BV32_SGE(local_id_z$1, 0bv32);
  requires BV32_SGE(local_id_z$2, 0bv32);
  requires BV32_SLT(local_id_z$1, group_size_z);
  requires BV32_SLT(local_id_z$2, group_size_z);
  requires !_WRITE_HAS_OCCURRED_$$_ZZ3fooPiE1x$1 ==> _WRITE_SOURCE_$$_ZZ3fooPiE1x$1 == 0bv32;
  requires !_READ_HAS_OCCURRED_$$_ZZ3fooPiE1x$1 ==> _READ_SOURCE_$$_ZZ3fooPiE1x$1 == 0bv32;
  requires !_ATOMIC_HAS_OCCURRED_$$_ZZ3fooPiE1x$1 ==> _ATOMIC_SOURCE_$$_ZZ3fooPiE1x$1 == 0bv32;
  requires _WRITE_HAS_OCCURRED_$$_ZZ3fooPiE1x$1 ==> _WRITE_SOURCE_$$_ZZ3fooPiE1x$1 == 1bv32 || _WRITE_SOURCE_$$_ZZ3fooPiE1x$1 == 2bv32 || _WRITE_SOURCE_$$_ZZ3fooPiE1x$1 == 3bv32 || _WRITE_SOURCE_$$_ZZ3fooPiE1x$1 == 4bv32;
  requires _READ_HAS_OCCURRED_$$_ZZ3fooPiE1x$1 ==> false;
  requires _ATOMIC_HAS_OCCURRED_$$_ZZ3fooPiE1x$1 ==> false;
  requires group_id_x$1 == group_id_x$2 && group_id_y$1 == group_id_y$2 && group_id_z$1 == group_id_z$2 ==> local_id_x$1 != local_id_x$2 || local_id_y$1 != local_id_y$2 || local_id_z$1 != local_id_z$2;
  modifies _WRITE_HAS_OCCURRED_$$_ZZ3fooPiE1x$1, _WRITE_OFFSET_$$_ZZ3fooPiE1x$1, _WRITE_VALUE_$$_ZZ3fooPiE1x$1, _WRITE_READ_BENIGN_FLAG_$$_ZZ3fooPiE1x$1, _WRITE_SOURCE_$$_ZZ3fooPiE1x$1, _WRITE_READ_BENIGN_FLAG_$$_ZZ3fooPiE1x$1;
  ensures !_WRITE_HAS_OCCURRED_$$_ZZ3fooPiE1x$1 ==> _WRITE_SOURCE_$$_ZZ3fooPiE1x$1 == 0bv32;
  ensures !_READ_HAS_OCCURRED_$$_ZZ3fooPiE1x$1 ==> _READ_SOURCE_$$_ZZ3fooPiE1x$1 == 0bv32;
  ensures !_ATOMIC_HAS_OCCURRED_$$_ZZ3fooPiE1x$1 ==> _ATOMIC_SOURCE_$$_ZZ3fooPiE1x$1 == 0bv32;
  ensures _WRITE_HAS_OCCURRED_$$_ZZ3fooPiE1x$1 ==> _WRITE_SOURCE_$$_ZZ3fooPiE1x$1 == 1bv32 || _WRITE_SOURCE_$$_ZZ3fooPiE1x$1 == 2bv32 || _WRITE_SOURCE_$$_ZZ3fooPiE1x$1 == 3bv32 || _WRITE_SOURCE_$$_ZZ3fooPiE1x$1 == 4bv32;
  ensures _READ_HAS_OCCURRED_$$_ZZ3fooPiE1x$1 ==> false;
  ensures _ATOMIC_HAS_OCCURRED_$$_ZZ3fooPiE1x$1 ==> false;



implementation {:kernel} $_Z3fooPi()
{
  var $i.0: bv32;
  var v0: bool;
  var _abstracted_call_arg_0$1: bv8;
  var _abstracted_call_arg_0$2: bv8;
  var _abstracted_call_arg_1$1: bv8;
  var _abstracted_call_arg_1$2: bv8;
  var _abstracted_call_arg_2$1: bv8;
  var _abstracted_call_arg_2$2: bv8;
  var _abstracted_call_arg_3$1: bv8;
  var _abstracted_call_arg_3$2: bv8;


  $entry:
    $i.0 := 0bv32;
    goto $for.cond;

  $for.cond:
    assert {:tag "accessed offsets satisfy predicates (source)"} _b1 ==> _WRITE_HAS_OCCURRED_$$_ZZ3fooPiE1x$1 ==> (BV32_AND(BV32_SUB(BV32_MUL(1bv32, 4bv32), 1bv32), _WRITE_OFFSET_$$_ZZ3fooPiE1x$1) == BV32_AND(BV32_SUB(BV32_MUL(1bv32, 4bv32), 1bv32), BV32_MUL(0bv32, 4bv32)) && _WRITE_SOURCE_$$_ZZ3fooPiE1x$1 == 1bv32) || (BV32_AND(BV32_SUB(BV32_MUL(1bv32, 4bv32), 1bv32), _WRITE_OFFSET_$$_ZZ3fooPiE1x$1) == BV32_AND(BV32_SUB(BV32_MUL(1bv32, 4bv32), 1bv32), BV32_ADD(BV32_MUL(0bv32, 4bv32), 1bv32)) && _WRITE_SOURCE_$$_ZZ3fooPiE1x$1 == 2bv32) || (BV32_AND(BV32_SUB(BV32_MUL(1bv32, 4bv32), 1bv32), _WRITE_OFFSET_$$_ZZ3fooPiE1x$1) == BV32_AND(BV32_SUB(BV32_MUL(1bv32, 4bv32), 1bv32), BV32_ADD(BV32_MUL(0bv32, 4bv32), 2bv32)) && _WRITE_SOURCE_$$_ZZ3fooPiE1x$1 == 3bv32) || (BV32_AND(BV32_SUB(BV32_MUL(1bv32, 4bv32), 1bv32), _WRITE_OFFSET_$$_ZZ3fooPiE1x$1) == BV32_AND(BV32_SUB(BV32_MUL(1bv32, 4bv32), 1bv32), BV32_ADD(BV32_MUL(0bv32, 4bv32), 3bv32)) && _WRITE_SOURCE_$$_ZZ3fooPiE1x$1 == 4bv32);
    assert {:tag "accessed offsets satisfy predicates"} _b0 ==> _WRITE_HAS_OCCURRED_$$_ZZ3fooPiE1x$1 ==> BV32_AND(BV32_SUB(BV32_MUL(1bv32, 4bv32), 1bv32), _WRITE_OFFSET_$$_ZZ3fooPiE1x$1) == BV32_AND(BV32_SUB(BV32_MUL(1bv32, 4bv32), 1bv32), BV32_MUL(0bv32, 4bv32)) || BV32_AND(BV32_SUB(BV32_MUL(1bv32, 4bv32), 1bv32), _WRITE_OFFSET_$$_ZZ3fooPiE1x$1) == BV32_AND(BV32_SUB(BV32_MUL(1bv32, 4bv32), 1bv32), BV32_ADD(BV32_MUL(0bv32, 4bv32), 1bv32)) || BV32_AND(BV32_SUB(BV32_MUL(1bv32, 4bv32), 1bv32), _WRITE_OFFSET_$$_ZZ3fooPiE1x$1) == BV32_AND(BV32_SUB(BV32_MUL(1bv32, 4bv32), 1bv32), BV32_ADD(BV32_MUL(0bv32, 4bv32), 2bv32)) || BV32_AND(BV32_SUB(BV32_MUL(1bv32, 4bv32), 1bv32), _WRITE_OFFSET_$$_ZZ3fooPiE1x$1) == BV32_AND(BV32_SUB(BV32_MUL(1bv32, 4bv32), 1bv32), BV32_ADD(BV32_MUL(0bv32, 4bv32), 3bv32));
    assert _ATOMIC_HAS_OCCURRED_$$_ZZ3fooPiE1x$1 ==> false;
    assert _READ_HAS_OCCURRED_$$_ZZ3fooPiE1x$1 ==> false;
    assert _WRITE_HAS_OCCURRED_$$_ZZ3fooPiE1x$1 ==> _WRITE_SOURCE_$$_ZZ3fooPiE1x$1 == 1bv32 || _WRITE_SOURCE_$$_ZZ3fooPiE1x$1 == 2bv32 || _WRITE_SOURCE_$$_ZZ3fooPiE1x$1 == 3bv32 || _WRITE_SOURCE_$$_ZZ3fooPiE1x$1 == 4bv32;
    assert !_ATOMIC_HAS_OCCURRED_$$_ZZ3fooPiE1x$1 ==> _ATOMIC_SOURCE_$$_ZZ3fooPiE1x$1 == 0bv32;
    assert !_READ_HAS_OCCURRED_$$_ZZ3fooPiE1x$1 ==> _READ_SOURCE_$$_ZZ3fooPiE1x$1 == 0bv32;
    assert !_WRITE_HAS_OCCURRED_$$_ZZ3fooPiE1x$1 ==> _WRITE_SOURCE_$$_ZZ3fooPiE1x$1 == 0bv32;
    v0 := BV32_ULT($i.0, 8bv32);
    goto $truebb, $falsebb;

  $falsebb:
    assume {:partition} !v0 && !v0;
    return;

  $truebb:
    assume {:partition} v0 && v0;
    havoc _abstracted_call_arg_0$1, _abstracted_call_arg_0$2;
    call {:sourceloc} {:line 15} {:col 5} {:fname "kernel.cu"} {:dir "/data/install/gpuverify/testsuite/CUDA/pointertests/cast"} _LOG_WRITE_$$_ZZ3fooPiE1x(true, BV32_MUL($i.0, 4bv32), 0bv8, _abstracted_call_arg_0$1, 1bv32);
    call _UPDATE_WRITE_READ_BENIGN_FLAG_$$_ZZ3fooPiE1x(true, BV32_MUL($i.0, 4bv32));
    assume {:do_not_predicate} {:captureState "check_state_0"} true;
    call {:state_id "check_state_0"} {:sourceloc} {:line 15} {:col 5} {:fname "kernel.cu"} {:dir "/data/install/gpuverify/testsuite/CUDA/pointertests/cast"} _CHECK_WRITE_$$_ZZ3fooPiE1x(true, BV32_MUL($i.0, 4bv32), 0bv8);
    call _WARP_SYNC();
    havoc _abstracted_call_arg_1$1, _abstracted_call_arg_1$2;
    call {:sourceloc} {:line 15} {:col 5} {:fname "kernel.cu"} {:dir "/data/install/gpuverify/testsuite/CUDA/pointertests/cast"} _LOG_WRITE_$$_ZZ3fooPiE1x(true, BV32_ADD(BV32_MUL($i.0, 4bv32), 1bv32), 0bv8, _abstracted_call_arg_1$1, 2bv32);
    call _UPDATE_WRITE_READ_BENIGN_FLAG_$$_ZZ3fooPiE1x(true, BV32_ADD(BV32_MUL($i.0, 4bv32), 1bv32));
    assume {:do_not_predicate} {:captureState "check_state_1"} true;
    call {:state_id "check_state_1"} {:sourceloc} {:line 15} {:col 5} {:fname "kernel.cu"} {:dir "/data/install/gpuverify/testsuite/CUDA/pointertests/cast"} _CHECK_WRITE_$$_ZZ3fooPiE1x(true, BV32_ADD(BV32_MUL($i.0, 4bv32), 1bv32), 0bv8);
    call _WARP_SYNC();
    havoc _abstracted_call_arg_2$1, _abstracted_call_arg_2$2;
    call {:sourceloc} {:line 15} {:col 5} {:fname "kernel.cu"} {:dir "/data/install/gpuverify/testsuite/CUDA/pointertests/cast"} _LOG_WRITE_$$_ZZ3fooPiE1x(true, BV32_ADD(BV32_MUL($i.0, 4bv32), 2bv32), 0bv8, _abstracted_call_arg_2$1, 3bv32);
    call _UPDATE_WRITE_READ_BENIGN_FLAG_$$_ZZ3fooPiE1x(true, BV32_ADD(BV32_MUL($i.0, 4bv32), 2bv32));
    assume {:do_not_predicate} {:captureState "check_state_2"} true;
    call {:state_id "check_state_2"} {:sourceloc} {:line 15} {:col 5} {:fname "kernel.cu"} {:dir "/data/install/gpuverify/testsuite/CUDA/pointertests/cast"} _CHECK_WRITE_$$_ZZ3fooPiE1x(true, BV32_ADD(BV32_MUL($i.0, 4bv32), 2bv32), 0bv8);
    call _WARP_SYNC();
    havoc _abstracted_call_arg_3$1, _abstracted_call_arg_3$2;
    call {:sourceloc} {:line 15} {:col 5} {:fname "kernel.cu"} {:dir "/data/install/gpuverify/testsuite/CUDA/pointertests/cast"} _LOG_WRITE_$$_ZZ3fooPiE1x(true, BV32_ADD(BV32_MUL($i.0, 4bv32), 3bv32), 0bv8, _abstracted_call_arg_3$1, 4bv32);
    call _UPDATE_WRITE_READ_BENIGN_FLAG_$$_ZZ3fooPiE1x(true, BV32_ADD(BV32_MUL($i.0, 4bv32), 3bv32));
    assume {:do_not_predicate} {:captureState "check_state_3"} true;
    call {:state_id "check_state_3"} {:sourceloc} {:line 15} {:col 5} {:fname "kernel.cu"} {:dir "/data/install/gpuverify/testsuite/CUDA/pointertests/cast"} _CHECK_WRITE_$$_ZZ3fooPiE1x(true, BV32_ADD(BV32_MUL($i.0, 4bv32), 3bv32), 0bv8);
    call _WARP_SYNC();
    $i.0 := BV32_ADD($i.0, 1bv32);
    goto $for.cond;
}



axiom (if group_size_y == 1bv32 then 1bv1 else 0bv1) != 0bv1;

axiom (if group_size_z == 1bv32 then 1bv1 else 0bv1) != 0bv1;

axiom (if num_groups_y == 1bv32 then 1bv1 else 0bv1) != 0bv1;

axiom (if num_groups_z == 1bv32 then 1bv1 else 0bv1) != 0bv1;

axiom (if group_size_x == 32bv32 then 1bv1 else 0bv1) != 0bv1;

axiom (if num_groups_x == 64bv32 then 1bv1 else 0bv1) != 0bv1;

procedure {:inline 1} {:barrier} barrier(__local_fence: bv1, __global_fence: bv1);
  requires {:barrier_divergence} group_id_x$1 == group_id_x$2 && group_id_y$1 == group_id_y$2 && group_id_z$1 == group_id_z$2 ==> true == true;



const {:local_id_x} local_id_x$1: bv32;

const {:local_id_x} local_id_x$2: bv32;

const {:local_id_y} local_id_y$1: bv32;

const {:local_id_y} local_id_y$2: bv32;

const {:local_id_z} local_id_z$1: bv32;

const {:local_id_z} local_id_z$2: bv32;

const {:group_id_x} group_id_x$1: bv32;

const {:group_id_x} group_id_x$2: bv32;

const {:group_id_y} group_id_y$1: bv32;

const {:group_id_y} group_id_y$2: bv32;

const {:group_id_z} group_id_z$1: bv32;

const {:group_id_z} group_id_z$2: bv32;

var _READ_SOURCE_$$p$1: bv32;

var _READ_VALUE_$$p$1: bv32;

procedure {:inline 1} _LOG_READ_$$p(_P$1: bool, _offset$1: bv32, _value$1: bv32, _source$1: bv32);
  modifies _READ_HAS_OCCURRED_$$p$1, _READ_OFFSET_$$p$1, _READ_VALUE_$$p$1, _READ_SOURCE_$$p$1;



implementation {:inline 1} _LOG_READ_$$p(_P$1: bool, _offset$1: bv32, _value$1: bv32, _source$1: bv32)
{
  var track: bool;


  _LOG_READ:
    havoc track;
    _READ_HAS_OCCURRED_$$p$1 := (if _P$1 && track then true else _READ_HAS_OCCURRED_$$p$1);
    _READ_OFFSET_$$p$1 := (if _P$1 && track then _offset$1 else _READ_OFFSET_$$p$1);
    _READ_VALUE_$$p$1 := (if _P$1 && track then _value$1 else _READ_VALUE_$$p$1);
    _READ_SOURCE_$$p$1 := (if _P$1 && track then _source$1 else _READ_SOURCE_$$p$1);
    return;
}



procedure _CHECK_READ_$$p(_P$2: bool, _offset$2: bv32, _value$2: bv32);
  requires {:array "$$p"} {:race} {:write_read} !(_P$2 && _WRITE_HAS_OCCURRED_$$p$1 && _WRITE_OFFSET_$$p$1 == _offset$2 && _WRITE_READ_BENIGN_FLAG_$$p$1);
  requires {:array "$$p"} {:race} {:atomic_read} !(_P$2 && _ATOMIC_HAS_OCCURRED_$$p$1 && _ATOMIC_OFFSET_$$p$1 == _offset$2);
  requires !_WRITE_HAS_OCCURRED_$$_ZZ3fooPiE1x$1 ==> _WRITE_SOURCE_$$_ZZ3fooPiE1x$1 == 0bv32;
  requires !_READ_HAS_OCCURRED_$$_ZZ3fooPiE1x$1 ==> _READ_SOURCE_$$_ZZ3fooPiE1x$1 == 0bv32;
  requires !_ATOMIC_HAS_OCCURRED_$$_ZZ3fooPiE1x$1 ==> _ATOMIC_SOURCE_$$_ZZ3fooPiE1x$1 == 0bv32;
  requires _WRITE_HAS_OCCURRED_$$_ZZ3fooPiE1x$1 ==> _WRITE_SOURCE_$$_ZZ3fooPiE1x$1 == 1bv32 || _WRITE_SOURCE_$$_ZZ3fooPiE1x$1 == 2bv32 || _WRITE_SOURCE_$$_ZZ3fooPiE1x$1 == 3bv32 || _WRITE_SOURCE_$$_ZZ3fooPiE1x$1 == 4bv32;
  requires _READ_HAS_OCCURRED_$$_ZZ3fooPiE1x$1 ==> false;
  requires _ATOMIC_HAS_OCCURRED_$$_ZZ3fooPiE1x$1 ==> false;
  ensures !_WRITE_HAS_OCCURRED_$$_ZZ3fooPiE1x$1 ==> _WRITE_SOURCE_$$_ZZ3fooPiE1x$1 == 0bv32;
  ensures !_READ_HAS_OCCURRED_$$_ZZ3fooPiE1x$1 ==> _READ_SOURCE_$$_ZZ3fooPiE1x$1 == 0bv32;
  ensures !_ATOMIC_HAS_OCCURRED_$$_ZZ3fooPiE1x$1 ==> _ATOMIC_SOURCE_$$_ZZ3fooPiE1x$1 == 0bv32;
  ensures _WRITE_HAS_OCCURRED_$$_ZZ3fooPiE1x$1 ==> _WRITE_SOURCE_$$_ZZ3fooPiE1x$1 == 1bv32 || _WRITE_SOURCE_$$_ZZ3fooPiE1x$1 == 2bv32 || _WRITE_SOURCE_$$_ZZ3fooPiE1x$1 == 3bv32 || _WRITE_SOURCE_$$_ZZ3fooPiE1x$1 == 4bv32;
  ensures _READ_HAS_OCCURRED_$$_ZZ3fooPiE1x$1 ==> false;
  ensures _ATOMIC_HAS_OCCURRED_$$_ZZ3fooPiE1x$1 ==> false;



var _WRITE_SOURCE_$$p$1: bv32;

var _WRITE_VALUE_$$p$1: bv32;

var _WRITE_READ_BENIGN_FLAG_$$p$1: bool;

procedure {:inline 1} _LOG_WRITE_$$p(_P$1: bool, _offset$1: bv32, _value$1: bv32, _value_old$1: bv32, _source$1: bv32);
  modifies _WRITE_HAS_OCCURRED_$$p$1, _WRITE_OFFSET_$$p$1, _WRITE_VALUE_$$p$1, _WRITE_READ_BENIGN_FLAG_$$p$1, _WRITE_SOURCE_$$p$1;



implementation {:inline 1} _LOG_WRITE_$$p(_P$1: bool, _offset$1: bv32, _value$1: bv32, _value_old$1: bv32, _source$1: bv32)
{
  var track: bool;


  _LOG_WRITE:
    havoc track;
    _WRITE_HAS_OCCURRED_$$p$1 := (if _P$1 && track then true else _WRITE_HAS_OCCURRED_$$p$1);
    _WRITE_OFFSET_$$p$1 := (if _P$1 && track then _offset$1 else _WRITE_OFFSET_$$p$1);
    _WRITE_VALUE_$$p$1 := (if _P$1 && track then _value$1 else _WRITE_VALUE_$$p$1);
    _WRITE_READ_BENIGN_FLAG_$$p$1 := (if _P$1 && track then _value$1 != _value_old$1 else _WRITE_READ_BENIGN_FLAG_$$p$1);
    _WRITE_SOURCE_$$p$1 := (if _P$1 && track then _source$1 else _WRITE_SOURCE_$$p$1);
    return;
}



procedure _CHECK_WRITE_$$p(_P$2: bool, _offset$2: bv32, _value$2: bv32);
  requires {:array "$$p"} {:race} {:write_write} !(_P$2 && _WRITE_HAS_OCCURRED_$$p$1 && _WRITE_OFFSET_$$p$1 == _offset$2 && _WRITE_VALUE_$$p$1 != _value$2);
  requires {:array "$$p"} {:race} {:read_write} !(_P$2 && _READ_HAS_OCCURRED_$$p$1 && _READ_OFFSET_$$p$1 == _offset$2 && _READ_VALUE_$$p$1 != _value$2);
  requires {:array "$$p"} {:race} {:atomic_write} !(_P$2 && _ATOMIC_HAS_OCCURRED_$$p$1 && _ATOMIC_OFFSET_$$p$1 == _offset$2);
  requires !_WRITE_HAS_OCCURRED_$$_ZZ3fooPiE1x$1 ==> _WRITE_SOURCE_$$_ZZ3fooPiE1x$1 == 0bv32;
  requires !_READ_HAS_OCCURRED_$$_ZZ3fooPiE1x$1 ==> _READ_SOURCE_$$_ZZ3fooPiE1x$1 == 0bv32;
  requires !_ATOMIC_HAS_OCCURRED_$$_ZZ3fooPiE1x$1 ==> _ATOMIC_SOURCE_$$_ZZ3fooPiE1x$1 == 0bv32;
  requires _WRITE_HAS_OCCURRED_$$_ZZ3fooPiE1x$1 ==> _WRITE_SOURCE_$$_ZZ3fooPiE1x$1 == 1bv32 || _WRITE_SOURCE_$$_ZZ3fooPiE1x$1 == 2bv32 || _WRITE_SOURCE_$$_ZZ3fooPiE1x$1 == 3bv32 || _WRITE_SOURCE_$$_ZZ3fooPiE1x$1 == 4bv32;
  requires _READ_HAS_OCCURRED_$$_ZZ3fooPiE1x$1 ==> false;
  requires _ATOMIC_HAS_OCCURRED_$$_ZZ3fooPiE1x$1 ==> false;
  ensures !_WRITE_HAS_OCCURRED_$$_ZZ3fooPiE1x$1 ==> _WRITE_SOURCE_$$_ZZ3fooPiE1x$1 == 0bv32;
  ensures !_READ_HAS_OCCURRED_$$_ZZ3fooPiE1x$1 ==> _READ_SOURCE_$$_ZZ3fooPiE1x$1 == 0bv32;
  ensures !_ATOMIC_HAS_OCCURRED_$$_ZZ3fooPiE1x$1 ==> _ATOMIC_SOURCE_$$_ZZ3fooPiE1x$1 == 0bv32;
  ensures _WRITE_HAS_OCCURRED_$$_ZZ3fooPiE1x$1 ==> _WRITE_SOURCE_$$_ZZ3fooPiE1x$1 == 1bv32 || _WRITE_SOURCE_$$_ZZ3fooPiE1x$1 == 2bv32 || _WRITE_SOURCE_$$_ZZ3fooPiE1x$1 == 3bv32 || _WRITE_SOURCE_$$_ZZ3fooPiE1x$1 == 4bv32;
  ensures _READ_HAS_OCCURRED_$$_ZZ3fooPiE1x$1 ==> false;
  ensures _ATOMIC_HAS_OCCURRED_$$_ZZ3fooPiE1x$1 ==> false;



var _ATOMIC_SOURCE_$$p$1: bv32;

procedure {:inline 1} _LOG_ATOMIC_$$p(_P$1: bool, _offset$1: bv32, _source$1: bv32);
  modifies _ATOMIC_HAS_OCCURRED_$$p$1, _ATOMIC_OFFSET_$$p$1, _ATOMIC_SOURCE_$$p$1;



implementation {:inline 1} _LOG_ATOMIC_$$p(_P$1: bool, _offset$1: bv32, _source$1: bv32)
{
  var track: bool;


  _LOG_ATOMIC:
    havoc track;
    _ATOMIC_HAS_OCCURRED_$$p$1 := (if _P$1 && track then true else _ATOMIC_HAS_OCCURRED_$$p$1);
    _ATOMIC_OFFSET_$$p$1 := (if _P$1 && track then _offset$1 else _ATOMIC_OFFSET_$$p$1);
    _ATOMIC_SOURCE_$$p$1 := (if _P$1 && track then _source$1 else _ATOMIC_SOURCE_$$p$1);
    return;
}



procedure _CHECK_ATOMIC_$$p(_P$2: bool, _offset$2: bv32);
  requires {:array "$$p"} {:race} {:write_atomic} !(_P$2 && _WRITE_HAS_OCCURRED_$$p$1 && _WRITE_OFFSET_$$p$1 == _offset$2);
  requires {:array "$$p"} {:race} {:read_atomic} !(_P$2 && _READ_HAS_OCCURRED_$$p$1 && _READ_OFFSET_$$p$1 == _offset$2);
  requires !_WRITE_HAS_OCCURRED_$$_ZZ3fooPiE1x$1 ==> _WRITE_SOURCE_$$_ZZ3fooPiE1x$1 == 0bv32;
  requires !_READ_HAS_OCCURRED_$$_ZZ3fooPiE1x$1 ==> _READ_SOURCE_$$_ZZ3fooPiE1x$1 == 0bv32;
  requires !_ATOMIC_HAS_OCCURRED_$$_ZZ3fooPiE1x$1 ==> _ATOMIC_SOURCE_$$_ZZ3fooPiE1x$1 == 0bv32;
  requires _WRITE_HAS_OCCURRED_$$_ZZ3fooPiE1x$1 ==> _WRITE_SOURCE_$$_ZZ3fooPiE1x$1 == 1bv32 || _WRITE_SOURCE_$$_ZZ3fooPiE1x$1 == 2bv32 || _WRITE_SOURCE_$$_ZZ3fooPiE1x$1 == 3bv32 || _WRITE_SOURCE_$$_ZZ3fooPiE1x$1 == 4bv32;
  requires _READ_HAS_OCCURRED_$$_ZZ3fooPiE1x$1 ==> false;
  requires _ATOMIC_HAS_OCCURRED_$$_ZZ3fooPiE1x$1 ==> false;
  ensures !_WRITE_HAS_OCCURRED_$$_ZZ3fooPiE1x$1 ==> _WRITE_SOURCE_$$_ZZ3fooPiE1x$1 == 0bv32;
  ensures !_READ_HAS_OCCURRED_$$_ZZ3fooPiE1x$1 ==> _READ_SOURCE_$$_ZZ3fooPiE1x$1 == 0bv32;
  ensures !_ATOMIC_HAS_OCCURRED_$$_ZZ3fooPiE1x$1 ==> _ATOMIC_SOURCE_$$_ZZ3fooPiE1x$1 == 0bv32;
  ensures _WRITE_HAS_OCCURRED_$$_ZZ3fooPiE1x$1 ==> _WRITE_SOURCE_$$_ZZ3fooPiE1x$1 == 1bv32 || _WRITE_SOURCE_$$_ZZ3fooPiE1x$1 == 2bv32 || _WRITE_SOURCE_$$_ZZ3fooPiE1x$1 == 3bv32 || _WRITE_SOURCE_$$_ZZ3fooPiE1x$1 == 4bv32;
  ensures _READ_HAS_OCCURRED_$$_ZZ3fooPiE1x$1 ==> false;
  ensures _ATOMIC_HAS_OCCURRED_$$_ZZ3fooPiE1x$1 ==> false;



procedure {:inline 1} _UPDATE_WRITE_READ_BENIGN_FLAG_$$p(_P$2: bool, _offset$2: bv32);
  modifies _WRITE_READ_BENIGN_FLAG_$$p$1;



implementation {:inline 1} _UPDATE_WRITE_READ_BENIGN_FLAG_$$p(_P$2: bool, _offset$2: bv32)
{

  _UPDATE_BENIGN_FLAG:
    _WRITE_READ_BENIGN_FLAG_$$p$1 := (if _P$2 && _WRITE_HAS_OCCURRED_$$p$1 && _WRITE_OFFSET_$$p$1 == _offset$2 then false else _WRITE_READ_BENIGN_FLAG_$$p$1);
    return;
}



var _READ_SOURCE_$$_ZZ3fooPiE1x$1: bv32;

var _READ_VALUE_$$_ZZ3fooPiE1x$1: bv8;

procedure {:inline 1} _LOG_READ_$$_ZZ3fooPiE1x(_P$1: bool, _offset$1: bv32, _value$1: bv8, _source$1: bv32);
  modifies _READ_HAS_OCCURRED_$$_ZZ3fooPiE1x$1, _READ_OFFSET_$$_ZZ3fooPiE1x$1, _READ_VALUE_$$_ZZ3fooPiE1x$1, _READ_SOURCE_$$_ZZ3fooPiE1x$1;



implementation {:inline 1} _LOG_READ_$$_ZZ3fooPiE1x(_P$1: bool, _offset$1: bv32, _value$1: bv8, _source$1: bv32)
{
  var track: bool;


  _LOG_READ:
    havoc track;
    _READ_HAS_OCCURRED_$$_ZZ3fooPiE1x$1 := (if _P$1 && track then true else _READ_HAS_OCCURRED_$$_ZZ3fooPiE1x$1);
    _READ_OFFSET_$$_ZZ3fooPiE1x$1 := (if _P$1 && track then _offset$1 else _READ_OFFSET_$$_ZZ3fooPiE1x$1);
    _READ_VALUE_$$_ZZ3fooPiE1x$1 := (if _P$1 && track then _value$1 else _READ_VALUE_$$_ZZ3fooPiE1x$1);
    _READ_SOURCE_$$_ZZ3fooPiE1x$1 := (if _P$1 && track then _source$1 else _READ_SOURCE_$$_ZZ3fooPiE1x$1);
    return;
}



procedure _CHECK_READ_$$_ZZ3fooPiE1x(_P$2: bool, _offset$2: bv32, _value$2: bv8);
  requires {:array "$$_ZZ3fooPiE1x"} {:race} {:write_read} !(_P$2 && _WRITE_HAS_OCCURRED_$$_ZZ3fooPiE1x$1 && _WRITE_OFFSET_$$_ZZ3fooPiE1x$1 == _offset$2 && _WRITE_READ_BENIGN_FLAG_$$_ZZ3fooPiE1x$1 && group_id_x$1 == group_id_x$2 && group_id_y$1 == group_id_y$2 && group_id_z$1 == group_id_z$2);
  requires {:array "$$_ZZ3fooPiE1x"} {:race} {:atomic_read} !(_P$2 && _ATOMIC_HAS_OCCURRED_$$_ZZ3fooPiE1x$1 && _ATOMIC_OFFSET_$$_ZZ3fooPiE1x$1 == _offset$2 && group_id_x$1 == group_id_x$2 && group_id_y$1 == group_id_y$2 && group_id_z$1 == group_id_z$2);
  requires !_WRITE_HAS_OCCURRED_$$_ZZ3fooPiE1x$1 ==> _WRITE_SOURCE_$$_ZZ3fooPiE1x$1 == 0bv32;
  requires !_READ_HAS_OCCURRED_$$_ZZ3fooPiE1x$1 ==> _READ_SOURCE_$$_ZZ3fooPiE1x$1 == 0bv32;
  requires !_ATOMIC_HAS_OCCURRED_$$_ZZ3fooPiE1x$1 ==> _ATOMIC_SOURCE_$$_ZZ3fooPiE1x$1 == 0bv32;
  requires _WRITE_HAS_OCCURRED_$$_ZZ3fooPiE1x$1 ==> _WRITE_SOURCE_$$_ZZ3fooPiE1x$1 == 1bv32 || _WRITE_SOURCE_$$_ZZ3fooPiE1x$1 == 2bv32 || _WRITE_SOURCE_$$_ZZ3fooPiE1x$1 == 3bv32 || _WRITE_SOURCE_$$_ZZ3fooPiE1x$1 == 4bv32;
  requires _READ_HAS_OCCURRED_$$_ZZ3fooPiE1x$1 ==> false;
  requires _ATOMIC_HAS_OCCURRED_$$_ZZ3fooPiE1x$1 ==> false;
  ensures !_WRITE_HAS_OCCURRED_$$_ZZ3fooPiE1x$1 ==> _WRITE_SOURCE_$$_ZZ3fooPiE1x$1 == 0bv32;
  ensures !_READ_HAS_OCCURRED_$$_ZZ3fooPiE1x$1 ==> _READ_SOURCE_$$_ZZ3fooPiE1x$1 == 0bv32;
  ensures !_ATOMIC_HAS_OCCURRED_$$_ZZ3fooPiE1x$1 ==> _ATOMIC_SOURCE_$$_ZZ3fooPiE1x$1 == 0bv32;
  ensures _WRITE_HAS_OCCURRED_$$_ZZ3fooPiE1x$1 ==> _WRITE_SOURCE_$$_ZZ3fooPiE1x$1 == 1bv32 || _WRITE_SOURCE_$$_ZZ3fooPiE1x$1 == 2bv32 || _WRITE_SOURCE_$$_ZZ3fooPiE1x$1 == 3bv32 || _WRITE_SOURCE_$$_ZZ3fooPiE1x$1 == 4bv32;
  ensures _READ_HAS_OCCURRED_$$_ZZ3fooPiE1x$1 ==> false;
  ensures _ATOMIC_HAS_OCCURRED_$$_ZZ3fooPiE1x$1 ==> false;



var _WRITE_SOURCE_$$_ZZ3fooPiE1x$1: bv32;

var _WRITE_VALUE_$$_ZZ3fooPiE1x$1: bv8;

var _WRITE_READ_BENIGN_FLAG_$$_ZZ3fooPiE1x$1: bool;

procedure {:inline 1} _LOG_WRITE_$$_ZZ3fooPiE1x(_P$1: bool, _offset$1: bv32, _value$1: bv8, _value_old$1: bv8, _source$1: bv32);
  modifies _WRITE_HAS_OCCURRED_$$_ZZ3fooPiE1x$1, _WRITE_OFFSET_$$_ZZ3fooPiE1x$1, _WRITE_VALUE_$$_ZZ3fooPiE1x$1, _WRITE_READ_BENIGN_FLAG_$$_ZZ3fooPiE1x$1, _WRITE_SOURCE_$$_ZZ3fooPiE1x$1;



implementation {:inline 1} _LOG_WRITE_$$_ZZ3fooPiE1x(_P$1: bool, _offset$1: bv32, _value$1: bv8, _value_old$1: bv8, _source$1: bv32)
{
  var track: bool;


  _LOG_WRITE:
    havoc track;
    _WRITE_HAS_OCCURRED_$$_ZZ3fooPiE1x$1 := (if _P$1 && track then true else _WRITE_HAS_OCCURRED_$$_ZZ3fooPiE1x$1);
    _WRITE_OFFSET_$$_ZZ3fooPiE1x$1 := (if _P$1 && track then _offset$1 else _WRITE_OFFSET_$$_ZZ3fooPiE1x$1);
    _WRITE_VALUE_$$_ZZ3fooPiE1x$1 := (if _P$1 && track then _value$1 else _WRITE_VALUE_$$_ZZ3fooPiE1x$1);
    _WRITE_READ_BENIGN_FLAG_$$_ZZ3fooPiE1x$1 := (if _P$1 && track then _value$1 != _value_old$1 else _WRITE_READ_BENIGN_FLAG_$$_ZZ3fooPiE1x$1);
    _WRITE_SOURCE_$$_ZZ3fooPiE1x$1 := (if _P$1 && track then _source$1 else _WRITE_SOURCE_$$_ZZ3fooPiE1x$1);
    return;
}



procedure _CHECK_WRITE_$$_ZZ3fooPiE1x(_P$2: bool, _offset$2: bv32, _value$2: bv8);
  requires {:array "$$_ZZ3fooPiE1x"} {:race} {:write_write} !(_P$2 && _WRITE_HAS_OCCURRED_$$_ZZ3fooPiE1x$1 && _WRITE_OFFSET_$$_ZZ3fooPiE1x$1 == _offset$2 && _WRITE_VALUE_$$_ZZ3fooPiE1x$1 != _value$2 && group_id_x$1 == group_id_x$2 && group_id_y$1 == group_id_y$2 && group_id_z$1 == group_id_z$2);
  requires {:array "$$_ZZ3fooPiE1x"} {:race} {:read_write} !(_P$2 && _READ_HAS_OCCURRED_$$_ZZ3fooPiE1x$1 && _READ_OFFSET_$$_ZZ3fooPiE1x$1 == _offset$2 && _READ_VALUE_$$_ZZ3fooPiE1x$1 != _value$2 && group_id_x$1 == group_id_x$2 && group_id_y$1 == group_id_y$2 && group_id_z$1 == group_id_z$2);
  requires {:array "$$_ZZ3fooPiE1x"} {:race} {:atomic_write} !(_P$2 && _ATOMIC_HAS_OCCURRED_$$_ZZ3fooPiE1x$1 && _ATOMIC_OFFSET_$$_ZZ3fooPiE1x$1 == _offset$2 && group_id_x$1 == group_id_x$2 && group_id_y$1 == group_id_y$2 && group_id_z$1 == group_id_z$2);
  requires !_WRITE_HAS_OCCURRED_$$_ZZ3fooPiE1x$1 ==> _WRITE_SOURCE_$$_ZZ3fooPiE1x$1 == 0bv32;
  requires !_READ_HAS_OCCURRED_$$_ZZ3fooPiE1x$1 ==> _READ_SOURCE_$$_ZZ3fooPiE1x$1 == 0bv32;
  requires !_ATOMIC_HAS_OCCURRED_$$_ZZ3fooPiE1x$1 ==> _ATOMIC_SOURCE_$$_ZZ3fooPiE1x$1 == 0bv32;
  requires _WRITE_HAS_OCCURRED_$$_ZZ3fooPiE1x$1 ==> _WRITE_SOURCE_$$_ZZ3fooPiE1x$1 == 1bv32 || _WRITE_SOURCE_$$_ZZ3fooPiE1x$1 == 2bv32 || _WRITE_SOURCE_$$_ZZ3fooPiE1x$1 == 3bv32 || _WRITE_SOURCE_$$_ZZ3fooPiE1x$1 == 4bv32;
  requires _READ_HAS_OCCURRED_$$_ZZ3fooPiE1x$1 ==> false;
  requires _ATOMIC_HAS_OCCURRED_$$_ZZ3fooPiE1x$1 ==> false;
  ensures !_WRITE_HAS_OCCURRED_$$_ZZ3fooPiE1x$1 ==> _WRITE_SOURCE_$$_ZZ3fooPiE1x$1 == 0bv32;
  ensures !_READ_HAS_OCCURRED_$$_ZZ3fooPiE1x$1 ==> _READ_SOURCE_$$_ZZ3fooPiE1x$1 == 0bv32;
  ensures !_ATOMIC_HAS_OCCURRED_$$_ZZ3fooPiE1x$1 ==> _ATOMIC_SOURCE_$$_ZZ3fooPiE1x$1 == 0bv32;
  ensures _WRITE_HAS_OCCURRED_$$_ZZ3fooPiE1x$1 ==> _WRITE_SOURCE_$$_ZZ3fooPiE1x$1 == 1bv32 || _WRITE_SOURCE_$$_ZZ3fooPiE1x$1 == 2bv32 || _WRITE_SOURCE_$$_ZZ3fooPiE1x$1 == 3bv32 || _WRITE_SOURCE_$$_ZZ3fooPiE1x$1 == 4bv32;
  ensures _READ_HAS_OCCURRED_$$_ZZ3fooPiE1x$1 ==> false;
  ensures _ATOMIC_HAS_OCCURRED_$$_ZZ3fooPiE1x$1 ==> false;



var _ATOMIC_SOURCE_$$_ZZ3fooPiE1x$1: bv32;

procedure {:inline 1} _LOG_ATOMIC_$$_ZZ3fooPiE1x(_P$1: bool, _offset$1: bv32, _source$1: bv32);
  modifies _ATOMIC_HAS_OCCURRED_$$_ZZ3fooPiE1x$1, _ATOMIC_OFFSET_$$_ZZ3fooPiE1x$1, _ATOMIC_SOURCE_$$_ZZ3fooPiE1x$1;



implementation {:inline 1} _LOG_ATOMIC_$$_ZZ3fooPiE1x(_P$1: bool, _offset$1: bv32, _source$1: bv32)
{
  var track: bool;


  _LOG_ATOMIC:
    havoc track;
    _ATOMIC_HAS_OCCURRED_$$_ZZ3fooPiE1x$1 := (if _P$1 && track then true else _ATOMIC_HAS_OCCURRED_$$_ZZ3fooPiE1x$1);
    _ATOMIC_OFFSET_$$_ZZ3fooPiE1x$1 := (if _P$1 && track then _offset$1 else _ATOMIC_OFFSET_$$_ZZ3fooPiE1x$1);
    _ATOMIC_SOURCE_$$_ZZ3fooPiE1x$1 := (if _P$1 && track then _source$1 else _ATOMIC_SOURCE_$$_ZZ3fooPiE1x$1);
    return;
}



procedure _CHECK_ATOMIC_$$_ZZ3fooPiE1x(_P$2: bool, _offset$2: bv32);
  requires {:array "$$_ZZ3fooPiE1x"} {:race} {:write_atomic} !(_P$2 && _WRITE_HAS_OCCURRED_$$_ZZ3fooPiE1x$1 && _WRITE_OFFSET_$$_ZZ3fooPiE1x$1 == _offset$2 && group_id_x$1 == group_id_x$2 && group_id_y$1 == group_id_y$2 && group_id_z$1 == group_id_z$2);
  requires {:array "$$_ZZ3fooPiE1x"} {:race} {:read_atomic} !(_P$2 && _READ_HAS_OCCURRED_$$_ZZ3fooPiE1x$1 && _READ_OFFSET_$$_ZZ3fooPiE1x$1 == _offset$2 && group_id_x$1 == group_id_x$2 && group_id_y$1 == group_id_y$2 && group_id_z$1 == group_id_z$2);
  requires !_WRITE_HAS_OCCURRED_$$_ZZ3fooPiE1x$1 ==> _WRITE_SOURCE_$$_ZZ3fooPiE1x$1 == 0bv32;
  requires !_READ_HAS_OCCURRED_$$_ZZ3fooPiE1x$1 ==> _READ_SOURCE_$$_ZZ3fooPiE1x$1 == 0bv32;
  requires !_ATOMIC_HAS_OCCURRED_$$_ZZ3fooPiE1x$1 ==> _ATOMIC_SOURCE_$$_ZZ3fooPiE1x$1 == 0bv32;
  requires _WRITE_HAS_OCCURRED_$$_ZZ3fooPiE1x$1 ==> _WRITE_SOURCE_$$_ZZ3fooPiE1x$1 == 1bv32 || _WRITE_SOURCE_$$_ZZ3fooPiE1x$1 == 2bv32 || _WRITE_SOURCE_$$_ZZ3fooPiE1x$1 == 3bv32 || _WRITE_SOURCE_$$_ZZ3fooPiE1x$1 == 4bv32;
  requires _READ_HAS_OCCURRED_$$_ZZ3fooPiE1x$1 ==> false;
  requires _ATOMIC_HAS_OCCURRED_$$_ZZ3fooPiE1x$1 ==> false;
  ensures !_WRITE_HAS_OCCURRED_$$_ZZ3fooPiE1x$1 ==> _WRITE_SOURCE_$$_ZZ3fooPiE1x$1 == 0bv32;
  ensures !_READ_HAS_OCCURRED_$$_ZZ3fooPiE1x$1 ==> _READ_SOURCE_$$_ZZ3fooPiE1x$1 == 0bv32;
  ensures !_ATOMIC_HAS_OCCURRED_$$_ZZ3fooPiE1x$1 ==> _ATOMIC_SOURCE_$$_ZZ3fooPiE1x$1 == 0bv32;
  ensures _WRITE_HAS_OCCURRED_$$_ZZ3fooPiE1x$1 ==> _WRITE_SOURCE_$$_ZZ3fooPiE1x$1 == 1bv32 || _WRITE_SOURCE_$$_ZZ3fooPiE1x$1 == 2bv32 || _WRITE_SOURCE_$$_ZZ3fooPiE1x$1 == 3bv32 || _WRITE_SOURCE_$$_ZZ3fooPiE1x$1 == 4bv32;
  ensures _READ_HAS_OCCURRED_$$_ZZ3fooPiE1x$1 ==> false;
  ensures _ATOMIC_HAS_OCCURRED_$$_ZZ3fooPiE1x$1 ==> false;



procedure {:inline 1} _UPDATE_WRITE_READ_BENIGN_FLAG_$$_ZZ3fooPiE1x(_P$2: bool, _offset$2: bv32);
  modifies _WRITE_READ_BENIGN_FLAG_$$_ZZ3fooPiE1x$1;



implementation {:inline 1} _UPDATE_WRITE_READ_BENIGN_FLAG_$$_ZZ3fooPiE1x(_P$2: bool, _offset$2: bv32)
{

  _UPDATE_BENIGN_FLAG:
    _WRITE_READ_BENIGN_FLAG_$$_ZZ3fooPiE1x$1 := (if _P$2 && _WRITE_HAS_OCCURRED_$$_ZZ3fooPiE1x$1 && _WRITE_OFFSET_$$_ZZ3fooPiE1x$1 == _offset$2 then false else _WRITE_READ_BENIGN_FLAG_$$_ZZ3fooPiE1x$1);
    return;
}



implementation {:inline 1} barrier(__local_fence: bv1, __global_fence: bv1)
{

  __BarrierImpl:
    goto anon2_Then, anon2_Else;

  anon2_Else:
    assume {:partition} true;
    goto anon0;

  anon0:
    assume __local_fence != 0bv1 ==> !_READ_HAS_OCCURRED_$$_ZZ3fooPiE1x$1;
    assume __local_fence != 0bv1 ==> !_WRITE_HAS_OCCURRED_$$_ZZ3fooPiE1x$1;
    assume __local_fence != 0bv1 ==> !_ATOMIC_HAS_OCCURRED_$$_ZZ3fooPiE1x$1;
    goto anon1;

  anon1:
    assume group_id_x$1 == group_id_x$2 && group_id_y$1 == group_id_y$2 && group_id_z$1 == group_id_z$2 ==> __global_fence != 0bv1 ==> !_READ_HAS_OCCURRED_$$p$1;
    assume group_id_x$1 == group_id_x$2 && group_id_y$1 == group_id_y$2 && group_id_z$1 == group_id_z$2 ==> __global_fence != 0bv1 ==> !_WRITE_HAS_OCCURRED_$$p$1;
    assume group_id_x$1 == group_id_x$2 && group_id_y$1 == group_id_y$2 && group_id_z$1 == group_id_z$2 ==> __global_fence != 0bv1 ==> !_ATOMIC_HAS_OCCURRED_$$p$1;
    return;

  anon2_Then:
    assume {:partition} false;
    return;
}



function {:bvbuiltin "bvsgt"} BV32_SGT(bv32, bv32) : bool;

function {:bvbuiltin "bvsge"} BV32_SGE(bv32, bv32) : bool;

function {:bvbuiltin "bvslt"} BV32_SLT(bv32, bv32) : bool;

function {:bvbuiltin "bvsub"} BV32_SUB(bv32, bv32) : bv32;

function {:bvbuiltin "bvand"} BV32_AND(bv32, bv32) : bv32;

const {:stage_id 0} {:existential true} _b0: bool;

const {:stage_id 0} {:existential true} _b1: bool;

procedure {:inline 1} _WARP_SYNC();



function {:bvbuiltin "bvsdiv"} BV32_DIV(bv32, bv32) : bv32;

implementation {:inline 1} _WARP_SYNC()
{

  entry:
    goto anon0_Then, anon0_Else;

  anon0_Then:
    assume {:partition} BV32_DIV(BV32_ADD(local_id_x$1, BV32_ADD(BV32_MUL(local_id_y$1, group_size_x), BV32_MUL(local_id_z$1, BV32_MUL(group_size_x, group_size_y)))), 32bv32) == BV32_DIV(BV32_ADD(local_id_x$2, BV32_ADD(BV32_MUL(local_id_y$2, group_size_x), BV32_MUL(local_id_z$2, BV32_MUL(group_size_x, group_size_y)))), 32bv32) && group_id_x$1 == group_id_x$2 && group_id_y$1 == group_id_y$2 && group_id_z$1 == group_id_z$2;
    goto reset_warps;

  reset_warps:
    assume !_READ_HAS_OCCURRED_$$p$1;
    assume !_WRITE_HAS_OCCURRED_$$p$1;
    assume !_ATOMIC_HAS_OCCURRED_$$p$1;
    assume !_READ_HAS_OCCURRED_$$_ZZ3fooPiE1x$1;
    assume !_WRITE_HAS_OCCURRED_$$_ZZ3fooPiE1x$1;
    assume !_ATOMIC_HAS_OCCURRED_$$_ZZ3fooPiE1x$1;
    return;

  anon0_Else:
    assume {:partition} !(BV32_DIV(BV32_ADD(local_id_x$1, BV32_ADD(BV32_MUL(local_id_y$1, group_size_x), BV32_MUL(local_id_z$1, BV32_MUL(group_size_x, group_size_y)))), 32bv32) == BV32_DIV(BV32_ADD(local_id_x$2, BV32_ADD(BV32_MUL(local_id_y$2, group_size_x), BV32_MUL(local_id_z$2, BV32_MUL(group_size_x, group_size_y)))), 32bv32) && group_id_x$1 == group_id_x$2 && group_id_y$1 == group_id_y$2 && group_id_z$1 == group_id_z$2);
    return;
}


