#!/usr/bin/env python

import sys
import os

def main(argv=None):
  if argv is None:
    argv = sys.argv
  progname = argv[0]

  if len(argv) != 2:
    print "Usage: " + argv[0] + " <maximum arity>"
    exit(1)

  n = int(argv[1])

  print "/* MACHINE GENERATED - do not edit this file */"
  print ""

  for i in range(0, n + 1):
    print "_DEVICE_QUALIFIER void __barrier_invariant_" + str(i) + "(bool expr"
    for j in range(0, i):
      print "  , unsigned int inst_expr_" + str(j)
    print ");"

  for i in range(0, n + 1):
    print "_DEVICE_QUALIFIER static __attribute__((always_inline)) __attribute__((overloadable)) void __barrier_invariant(bool expr"
    for j in range(0, i):
      print "  , unsigned int inst_expr_" + str(j);
    print ") { __barrier_invariant_" + str(i) + "(expr"
    for j in range(0, i):
      print "  , inst_expr_" + str(j);
    print "    );"
    print "}"

  for i in range(0, n + 1):
    print "void __barrier_invariant_binary_" + str(i) + "(bool expr"
    for j in range(0, i):
      print "  , unsigned int inst_expr_" + str(j) + "_0, unsigned int inst_expr_" + str(j) + "_1"
    print ");"

  for i in range(0, n + 1):
    print "static __attribute__((always_inline)) __attribute__((overloadable)) void __barrier_invariant_binary(bool expr"
    for j in range(0, i):
      print "  , unsigned int inst_expr_" + str(j) + "_0, unsigned int inst_expr_" + str(j) + "_1"
    print ") { __barrier_invariant_binary_" + str(i) + "(expr"
    for j in range(0, i):
      print "  , inst_expr_" + str(j) + "_0, inst_expr_" + str(j) + "_1";
    print "    );"
    print "}"

if __name__ == '__main__':
  sys.exit(main())
