# The Interval of Summations Abstraction for Parallel Prefix Sums: Additional Supporting Materials

This is the artifact that accompanies our POPL'14 paper.

We give two OpenCL experiments for showing the effectiveness of the Interval of Summations Abstraction.
We implement the interval of abstractions as a simple set of preprocessor macros and the quadratic Voigtlaender method.

We also provide a script for checking that the OpenCL kernels are free from data races using the GPUVerify tool.

## Prerequisites

* Python 2.73

* To run the tests:
  - OpenCL 1.0 or greater and an OpenCL-enabled device

* To check race-freedom:
  - GPUVerify, which is available at: http://multicore.doc.ic.ac.uk/tools/GPUVerify/download.php

## Build instructions

* Inside a *bash* shell set the environment variable `CLDIR` to point to your installation of the OpenCL SDK.
  This should be the base directory from which `lib` and `include` can be found.
  Export the variable like this:

```
export CLDIR=/path/to/opencl/installation
```

* Now build the executables:

```
make
```

* This should build two programs, `atester` and `vtester`, in the `src` directory.
  These implement the interval of abstractions (atester) and Voigtlaender method (vtester).

## Running the testers directly 

Each tester is invoked with the number of elements to perform the prefix sum and the chosen prefix sum algorithm. For example:

```
./atester 16 sklansky.cl
```

Invokes the abstract tester for the Sklansky algorithm over a 16 element-wide array.

## Running the experiments

```
* Run the experiment script:

```
./run_experiments.py | tee results.csv
```

* This will generate a `result.csv` file.

## Checking race-freedom

* Get GPUVerify from the URL above

* Edit GPUVerifyCommand in run_gpuverify_tests.py

* Run the GPUVerify script:

```
./run_gpuverify_tests.py
```

* This will generate csv to standard output which you can redirect to a file if you wish.

## Inspecting the invariants required to prove race-freedom

* Run the command:

```
grep __invariant *.cl
```

* This will show you all the places where invariants have been manually supplied to allow race-freedom to be proven.
