#ifndef __ABSTRACTION_H
#define __ABSTRACTION_H

#if defined(CONCRETE)

DECLARE_UF_BINARY(CIRC, int, int, int);
#define TYPE int
#define OPERATOR(X, Y) CIRC(X, Y)

#elif defined(ABSTRACT)

#define TYPE uint2
#define MAKE_PAIR(lower, upper) ((TYPE) { lower, upper })
#define GET_UPPER(X) (X.hi)
#define GET_LOWER(X) (X.lo)
#define TYPE_EQUAL(X,Y) ((GET_LOWER(X) == GET_LOWER(Y)) && (GET_UPPER(X) == GET_UPPER(Y)))
//#define TYPE_EQUAL(X,Y) all(X == Y)

// Identity is identified by bad interval (1, 0)
#define IDENTITY MAKE_PAIR(1, 0)

// Top is identified by bad interval (2, 0)
#define TOP MAKE_PAIR(2, 0)

#define OPERATOR(X, Y) \
  (  TYPE_EQUAL(X, IDENTITY)                                                  ? Y \
  : (TYPE_EQUAL(Y, IDENTITY)                                                  ? X \
  : (TYPE_EQUAL(X, TOP) | TYPE_EQUAL(Y, TOP) | (GET_UPPER(X) != GET_LOWER(Y)) ? TOP \
  :                                                                             MAKE_PAIR(GET_LOWER(X), GET_UPPER(Y)))))

#elif defined(OP1)
#define TYPE char
#define OPERATOR(X, Y) ((Y == 0) ? X : (((X == 0) && (Y == 1)) ? 1 : 2))
#define IDENTITY 0
#define MAKE_PAIR(lower, upper) lower
#define TYPE_EQUAL(X,Y) (X == Y)

#elif defined(OP2)
#define TYPE char
#define OPERATOR(X, Y) ((Y == 0) ? X : ((Y == 1) ? 1 : 2))
#define IDENTITY 0
#define MAKE_PAIR(lower, upper) lower
#define TYPE_EQUAL(X,Y) (X == Y)

#else
#error Must define CONCRETE or ABSTRACT or OP1 or OP2
#endif

#endif
