#include "abstraction.h"

#ifndef EXCLUSIVE

__kernel void abstract_check(__global TYPE *output, __global unsigned *error) {
  unsigned i = get_global_id(0);
  if (!TYPE_EQUAL(output[i], MAKE_PAIR(0, i+1))) {
    *error = 1;
  }
}

#else

__kernel void abstract_check(__global TYPE *output, __global unsigned *error) {
  unsigned i = get_global_id(0);
  if ((i == 0) && !TYPE_EQUAL(output[i], IDENTITY)) {
    *error = 1;
  }
  if ((i > 0) && !TYPE_EQUAL(output[i], MAKE_PAIR(0, i))) {
    *error = 1;
  }
}

#endif
