//pass
//--local_size=4096 --num_groups=1 -DABSTRACT -DN=8192 --no-infer koggestone.cl

#include "abstraction.h"

#ifdef NO_INVARIANTS
__kernel
#else
static __attribute__((always_inline)) 
#endif
void prefixsum(__global TYPE *input, __global TYPE *output, unsigned is_exclusive) {
  __local TYPE result[NELEMENTS_PER_GROUP];

  TYPE temp;
  unsigned tid = get_local_id(0);
  unsigned gid = get_global_id(0);
  result[tid] = input[gid];

  barrier(CLK_LOCAL_MEM_FENCE);

  for (unsigned offset = 1;
#ifndef NO_INVARIANTS
        __invariant(__no_read(result)), __invariant(__no_write(result)),
#endif
      offset < NELEMENTS_PER_GROUP;
      offset *= 2) 
  {
    if (tid >= offset)
    {
      temp = result[tid-offset];
    }

    barrier(CLK_LOCAL_MEM_FENCE);

    if (tid >= offset)
    {
      result[tid] = OPERATOR(temp, result[tid]);
    }

    barrier(CLK_LOCAL_MEM_FENCE);
  }

  if (is_exclusive) {
    output[gid] = (tid == 0) ? IDENTITY : result[tid-1];
  } else {
    output[gid] = result[tid];
  }

#ifdef FORCE_FAIL
  __assert(false);
#endif
}
