#include "abstraction.h"

#define __stringify_inner(x) #x
#define __stringify(x) __stringify_inner(x)
#include __stringify(INNER)

__kernel void meta1(__global TYPE *input, __global TYPE *output, __global TYPE *sum, unsigned is_exclusive) {
  unsigned tid = get_local_id(0);
  unsigned bid = get_group_id(0);
  prefixsum(input, output, is_exclusive);
  barrier(CLK_LOCAL_MEM_FENCE|CLK_GLOBAL_MEM_FENCE);
  if (tid == 0) {
    sum[bid] = is_exclusive ? OPERATOR(output[(bid+1)*NELEMENTS_PER_GROUP-1], input[(bid+1)*NELEMENTS_PER_GROUP-1])
                            : output[(bid+1)*NELEMENTS_PER_GROUP-1];
  }
}

