#!/usr/bin/env python

import subprocess
import os
import timeit

minPower = 1
maxPower = 31
numRuns = 3
GPUVerifyCommand = "/path/to/gpuverify" # Replace with the path to your GPUVerify installation

def RunCommand(command):
  options = {}

  # If using posix make sure started process is in a different
  # process group so that if the started process does something
  # crazy like... killing all processes in its process group 
  # we don't end up being killed ourself.
  if os.name == 'posix':
    options['preexec_fn'] = os.setsid

  processInstance=subprocess.Popen(command,
    stdout=subprocess.PIPE, 
    stderr=subprocess.STDOUT,
    **options
  )
  stdout=processInstance.communicate() #Allow program to run and wait for it to exit.    
  return processInstance.returncode == 0


def RunExperiment(kernel):

  runLength = [ 0 for i in range(0, numRuns) ]
  power = minPower
  while(power <= maxPower):

    nelements = 2**power
    if (nelements < 1024):
      N = nelements
    else:
      N = 1024

    runsSucceeded = True
    for runNumber in range(0, numRuns):

      start = timeit.default_timer()

      if (kernel == "sklansky.cl"):
        global_work_size = nelements/2
        local_work_size  = N/2
      elif (kernel == "koggestone.cl"):
        global_work_size = nelements
        local_work_size  = N
      elif (kernel == "brentkung.cl"):
        global_work_size = nelements/2
        local_work_size  = N/2
      elif (kernel == "blelloch-inclusive.cl"):
        global_work_size = nelements/2
        local_work_size  = N/2
      elif (kernel == "blelloch.cl"):
        global_work_size = nelements/2
        local_work_size  = N/2

      generalCommands = [ GPUVerifyCommand,
                 "-DABSTRACT",
                 "--no-infer",
                 "--no-source-loc-infer",
                 "--adversarial-abstraction",
                 "-DNELEMENTS_PER_GROUP=" + str(N),
                 "-DEXCLUSIVE" if kernel == "blelloch.cl" else "-DINCLUSIVE"
                ]


      runsSucceeded = RunCommand(
                generalCommands +
                [
                  "-DINNER=" + kernel,
                  "--local_size=" + str(local_work_size),
                  "--num_groups=" + str(global_work_size / local_work_size),
                  "meta1.cl" ])
      if not runsSucceeded:
        print "meta1 failed"
        break

      runsSucceeded = RunCommand(
                generalCommands +
                [ "--local_size=" + str(N),
                  "--num_groups=" + str(nelements/N),
                  "meta2.cl" ])
      if not runsSucceeded:
        print "meta2 failed"
        break

      runsSucceeded = RunCommand(
                generalCommands +
                [ "--local_size=" + str(N),
                  "--num_groups=" + str(nelements/N),
                  "check.cl" ])
      if not runsSucceeded:
        print "check failed"
        break

      runsSucceeded = RunCommand(
                generalCommands +
                [ "--local_size=" + str(N),
                  "--num_groups=" + str(nelements/N),
                  "init.cl" ])
      if not runsSucceeded:
        print "init failed"
        break

      end = timeit.default_timer()
      runLength[runNumber] = end - start
    print filename + ", N=2**" + str(power) + ", " + ", ".join([str(l) for l in runLength]) + ", Average: " + (str(sum(runLength)/len(runLength)) if runsSucceeded else "Failed")
    power = power + 1


for filename in [ "blelloch.cl", "brentkung.cl", "koggestone.cl", "sklansky.cl" ]:
  RunExperiment(filename)
