//pass
//--local_size=4096 --num_groups=1 -DABSTRACT -DN=8192 --no-infer sklansky.cl

#include "abstraction.h"

#ifdef NO_INVARIANTS
__kernel
#else
static __attribute__((always_inline)) 
#endif
void prefixsum(__global TYPE *input, __global TYPE *output, unsigned is_exclusive) {
  __local TYPE result[NELEMENTS_PER_GROUP];

  unsigned tid = get_local_id(0);
  unsigned gid = get_global_id(0);
  
  result[2*tid] = input[2*gid];
  result[2*tid+1] = input[2*gid+1];
  
  for (unsigned d = 1;
#ifndef NO_INVARIANTS
       __invariant((d & (d-1)) == 0),
#endif
       d < NELEMENTS_PER_GROUP; d *= 2) {
      barrier(CLK_LOCAL_MEM_FENCE);
      unsigned block = 2 * (tid - (tid & (d - 1)));
      unsigned me = block + (tid & (d - 1)) + d;
      unsigned spine = block + d - 1;
      result[me] = OPERATOR(result[spine], result[me]);
  }
  
  barrier(CLK_LOCAL_MEM_FENCE);

  if (is_exclusive) {
    output[2*gid] = (tid == 0) ? IDENTITY : result[2*tid-1];
    output[2*gid+1] = result[2*tid];
  } else {
    output[2*gid] = result[2*tid];
    output[2*gid+1] = result[2*tid+1];
  }

#ifdef FORCE_FAIL
  __assert(false);
#endif
}
