__kernel void voigtlander_op1(__global TYPE *input, __global TYPE *output, __global TYPE *sum) {
  unsigned tid = get_local_id(0);
  unsigned bid = get_group_id(0);
  prefixsum(input, output, /*is_exclusive*/0);
  barrier(CLK_LOCAL_MEM_FENCE|CLK_GLOBAL_MEM_FENCE);
  if (tid == 0) {
    sum[bid] = output[(bid+1)*NELEMENTS_PER_GROUP-1];
  }
}

__kernel void voigtlander_op2(__global TYPE *input, __global TYPE *output, __global TYPE *sum) {
  unsigned tid = get_local_id(0);
  unsigned bid = get_group_id(0);
  prefixsum(input, output, /*is_exclusive*/0);
  barrier(CLK_LOCAL_MEM_FENCE|CLK_GLOBAL_MEM_FENCE);
  if (tid == 0) {
    sum[bid] = output[(bid+1)*NELEMENTS_PER_GROUP-1];
  }
}

__kernel void inc_op1(__global TYPE *output, __global TYPE *sum) {
  unsigned bid = get_group_id(0);
  unsigned gid = get_global_id(0);
  output[gid] = OPERATOR(sum[bid], output[gid]);
}

__kernel void inc_op2(__global TYPE *output, __global TYPE *sum) {
  unsigned bid = get_group_id(0);
  unsigned gid = get_global_id(0);
  output[gid] = OPERATOR(sum[bid], output[gid]);
}

__kernel void check(__global TYPE *output, __global TYPE *expected, __global unsigned *error) {
  unsigned gid = get_global_id(0);
  if (!TYPE_EQUAL(output[gid], expected[gid])) {
    *error = 1;
  }
}
