#!/usr/bin/env python

import sys
import getopt
import subprocess

def gencmd(nthreads,op,rtype,proc):
  cmd = [ 
    'gpuverify',
    '--no-thread2-asserts',
    '--only-divergence',
    '-Ispecs/',
    '--num_groups=1',
    '--local_size=%d' % nthreads,
    '-DN=%d' % (nthreads*2), # number of elements
    '-D%s' % op,
    '-Drtype=%s' % rtype,
    '-D%s' % proc,
    '-DSPEC_ELEMENTWISE',
  ]
  cmd.append('kernel.cl')
  return cmd

def main(argv=None):
  if argv is None:
    argv = sys.argv
  progname = argv[0]

  try:
    opts, args = getopt.getopt(argv[1:],'h', 
      ['help', 'bitwidth=', 'op='])
  except getopt.GetoptError as getoptError:
    print "Error: [%s]" % (getoptError.msg)
    print 'Try %s --help' % progname
    return 1

  rtype = 'uint'
  op = 'BINOP_ADD'
  for o, a in opts:
    if o in ('-h', '--help'):
      print '%s [options] nthreads' % progname
      print ' --h, --help                     Display this message'
      print ' --op=[add|max|or]               Binary operator'
      print ' --bitwidth=[8|16|32]            Bitwidth of data'
      return 0
    if o in ('--op'):
      if a.lower() == 'add': op = 'BINOP_ADD'
      elif a.lower() == 'max': op = 'BINOP_MAX'
      elif a.lower() == 'or' : op = 'BINOP_OR'
      else:
        print 'Error: unrecognised operator for --op=%s' % a
        return 1
    if o in ('--bitwidth'):
      if a.lower() == '8': rtype = 'uchar'
      elif a.lower() == '16': rtype = 'ushort'
      elif a.lower() == '32': rtype = 'uint'
      else:
        print 'Error: unrecognised operator for --rtype=%s' % a
        return 1
  if len(args) != 1:
    print 'Error: must specify number of threads'
    return 1
  nthreads = int(args[0])

  for p in [ 'INC_UPSWEEP', 'INC_DOWNSWEEP', 'INC_ENDSPEC' ]:
    cmd = gencmd(nthreads, op, rtype, p)
    print ' '.join(cmd)
    proc = subprocess.Popen(cmd, shell=True)
    stdout, stderr = proc.communicate()
    assert proc.returncode == 0
  return 0

if __name__ == '__main__':
  sys.exit(main())
