#include "barrier_invariants_autogenerated_definitions.h"

#if !defined(__1D_WORK_GROUP) && !defined(__1D_THREAD_BLOCK)

#define __barrier_invariant(X, ...) !!! Barrier invariants currently only supported for 1D thread groups !!!    
#define __barrier_invariant_binary(X, ...) !!! Barrier invariants currently only supported for 1D thread groups !!!    

#else

#define __barrier_invariant(X, ...) \
    __non_temporal_loads_begin(), \
    __barrier_invariant(X, __VA_ARGS__), \
    __non_temporal_loads_end()

#define __barrier_invariant_binary(X, ...) \
    __non_temporal_loads_begin(), \
    __barrier_invariant_binary(X, __VA_ARGS__), \
    __non_temporal_loads_end()

#endif
