#!/usr/bin/env python

import sys
import os

def main(argv=None):
  if argv is None:
    argv = sys.argv
  progname = argv[0]

  if len(argv) != 2:
    print "Usage: " + argv[0] + " <maximum arity>"
    exit(1)

  n = int(argv[1])

  print "/* MACHINE GENERATED - do not edit this file */"

  for i in range(0, n + 1):
    print "#undef __barrier_invariant_" + str(i)
  for i in range(0, n + 1):
    print "#undef __barrier_invariant_binary_" + str(i)
  print
  for i in range(0, n + 1):
    definition = "#define __barrier_invariant_" + str(i) + "(X"
    for j in range(0, i):
      definition += ", I" + str(j)
    definition += ") __NOP"
    print definition
  for i in range(0, n + 1):
    definition = "#define __barrier_invariant_binary_" + str(i) + "(X"
    for j in range(0, i):
      definition += ", I" + str(j) + "_0, I" + str(j) + "_1"
    definition += ") __NOP"
    print definition

if __name__ == '__main__':
  sys.exit(main())
