#ifdef _MSC_VER
#include <windows.h>
#include <rtcapi.h>
int exception_handler(LPEXCEPTION_POINTERS p)
{
    printf("Exception detected during test execution!");
    exit(1);
}
int runtime_check_handler(int errorType, const char *filename, int linenumber, const char *moduleName, const char *format, ...)
{
    printf("Error type %d at %s line %d in %s", errorType, filename, linenumber, moduleName);
    exit(1);
}

#define ENABLE_WINDOWS_EXCEPTION_HANDLING \
  DWORD dwMode = SetErrorMode(SEM_NOGPFAULTERRORBOX); \
  SetErrorMode(dwMode | SEM_NOGPFAULTERRORBOX); \
  SetUnhandledExceptionFilter((LPTOP_LEVEL_EXCEPTION_FILTER)&exception_handler); \
  _RTC_SetErrorFunc(&runtime_check_handler);

#endif
