// IMPERIAL EDIT
#include "CLSmith.h"
// END IMPERIAL EDIT
/***************************************************************************
 *cr
 *cr            (C) Copyright 2010 The Board of Trustees of the
 *cr                        University of Illinois
 *cr                         All Rights Reserved
 *cr
 ***************************************************************************/

__kernel void spmv_jds_naive(__global float *dst_vector, __global float *d_data,
		       	     __global int *d_index, __global int *d_perm,
		             __global float *x_vec, const int dim, 
		             __constant int *jds_ptr_int,
		             __constant int *sh_zcnt_int,
                 __global int *emi_data
                 )
{
  	int ix = get_global_id(0);

  	if (ix < dim) {
    		float sum = 0.0f;
    		// 32 is warp size
    		int bound=sh_zcnt_int[ix/32];
// INJECTION
if (emi_data[239] < emi_data[205]) {
#include "emi0/subst.h"
#include "emi0/EMI_BLOCK.h"
}
// END INJECTION


	    	for(int k=0;k<bound;k++)
    		{	  
// INJECTION
if (emi_data[46] < emi_data[0]) {
#include "emi1/subst.h"
#include "emi1/EMI_BLOCK.h"
}
// END INJECTION
      			int j = jds_ptr_int[k] + ix;    
      			int in = d_index[j]; 
  
      			float d = d_data[j];
      			float t = x_vec[in];

      			sum += d*t; 
    		}  
  
    		dst_vector[d_perm[ix]] = sum; 
  	}
}
