#include <iostream>
#include <stdio.h>
#include <map>
#include <string>
#include <cstring>

// OpenCL header files
#ifdef __APPLE__
#include <OpenCL/cl.h>
//#include <OpenCL/cl_gl.h>
//#include <OpenCL/cl_gl_ext.h>
//#include <OpenCL/cl_ext.h>
#else
#include <CL/cl.h>
//#include <CL/cl_gl.h>
//#include <CL/cl_gl_ext.h>
//#include <CL/cl_ext.h>
#endif

using namespace std;

// IMPERIAL EDIT: add error checking macros
#define OCL_ERRCK_VAR(var) \
  { if (var != CL_SUCCESS) { fprintf(stderr, "OpenCL Error (%s: %d):\n", __FILE__, __LINE__); exit(1); } }
  
#define OCL_ERRCK_RETVAL(s) \
  { cl_int clerr = (s);\
    if (clerr != CL_SUCCESS) { fprintf(stderr, "OpenCL Error (%s: %d):\n", __FILE__, __LINE__); exit(1); } }

class OpenCL
{
public:
	OpenCL(int displayOutput);
	~OpenCL();
	void init();
	void createKernel(string kernelName);
	cl_kernel kernel(string kernelName);
	void gwSize(size_t theSize);
	cl_context ctxt();
	cl_command_queue q();
	void launch(string toLaunch);
	size_t localSize();
	
private:
	int                     VERBOSE;           // Display output text from various functions?
	size_t                  lwsize;            // Local work size.
	size_t                  gwsize;            // Global work size.
	cl_int                  ret;               // Holds the error code returned by cl functions.
	map<string, cl_kernel>  kernelArray;
	cl_context              context;
	cl_command_queue        command_queue;
	cl_program              program;

  cl_platform_id          clPlatform;
  cl_device_id            clDevice;
	
	void getDevices(cl_device_type deviceType);
	void buildKernel();
};
