#!/usr/bin/env python
# -*- coding: utf-8 -*-

from __future__ import print_function
import sys
import argparse
import os
import subprocess

MAX_EMI_BLOCK = 124

def keyof(benchmark,opt,sub):
  return "{0}-{1}-{2}".format(benchmark,opt,sub)

def main(argv=None):
  if argv is None:
    argv = sys.argv[1:]
  parser = argparse.ArgumentParser(description="Summarise emibench csv output")
  parser.add_argument("input", type=argparse.FileType('r'), help="CSV file to examine")
  parser.add_argument("--print_header", action="store_true", help="Print CSV header")
  args = parser.parse_args(argv)
  lines = args.input.readlines()
  map = {}
  benchmarks = []
  for l in lines:
    if l.startswith("#"):
      continue
    r = l.rstrip().split(",")
    assert len(r) == 5
    benchmark,opt,sub,emiblock,result = r
    emiblock = int(emiblock)
    assert 0 <= emiblock and emiblock <= MAX_EMI_BLOCK
    if benchmark not in benchmarks:
      benchmarks.append(benchmark)
    k = keyof(benchmark,opt,sub)
    if k not in map:
      map[k] = [ "?" for i in range(MAX_EMI_BLOCK+1) ]
    map[k][emiblock] = result
  for b in benchmarks:
    for (opt,sub) in [(0,0),(0,1),(1,0),(1,1)]:
      k = keyof(b,str(opt),str(sub))
      if "?" in map[k]: continue
      assert "?" not in map[k]
  if args.print_header:
    print("#                     __(opt,sub)___")
    print("#benchmark, emiblock, 00, 01, 10, 11, interesting")
  for b in benchmarks:
    for emiblock in range(MAX_EMI_BLOCK+1):
      row = [b, str(emiblock)]
      for (opt,sub) in [(0,0),(0,1),(1,0),(1,1)]:
        k = keyof(b,str(opt),str(sub))
        row.append(map[k][emiblock])
      if len(set(row[-4:])) != 1: # more than one
        row.append("*")
      else:
        row.append("-")
      print(",".join(row))
  return 0

if __name__ == '__main__':
  sys.exit(main())
